package com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant;

/**
 * @作者: bin
 * @創建時間: 2020-12-24 9:42
 * @更新時間: 2020-12-24 9:42
 * @描述:
 */
public interface PayMethodConstant {

    /**
     * 支付申请清单
     */
    String PAY_TYPE_CC = "CC"; //信用卡
    String PAY_TYPE_QRC = "QRC";//支付寶，微信
    String PAY_TYPE_OPS = "OPS";//八達通
    String PAY_TYPE_AE = "AE";//美国运通
    String PAY_TYPE_EPS = "EPS";
    String PAY_TYPE_INTEGRAL = "INTEGRAL";

    //扫码支付
    String PAY_TYPE_QR = "QR";
    String PAY_TYPE_ALP = "ALP";
    String PAY_TYPE_WCP = "WCP";
    /**
     * 付款方式清单
     * <p>
     * VC Visa卡
     * VC-QR Visa卡QR
     * <p>
     * MC 万事达卡
     * MC-QR 万事达卡QR
     * <p>
     * JCB  JCB
     * JCB-QR JCB QR
     * <p>
     * UP 银联
     * UP-QR 银联QR
     * <p>
     * AE AMEX
     * <p>
     * ALP 支付宝
     * WCP 微信支付
     */

    String PAY_WAY_CASH = "CASH"; //现金
    String PAY_WAY_CARD = "CC"; //信用卡
    String PAY_WAY_AE = "AE"; //AMEX
    String PAY_WAY_QR = "QR"; //QR /条码付款（例如VMJ QR，UP QR）
    String PAY_WAY_ALI_WCP = "ALP,WCP"; //微信，支付宝


    /**
     * 6.6 Settle Type List
     * Payment Type Description:
     *
     * VC   -- Visa Card
     * MC   -- Master Card
     * JCB  -- JCB
     * UP   -- Unionpay
     * UP-QR  -- Unionpay QR
     * AE  -- AMEX
     * ALP  -- Alipay
     * WCP --  Wechat Pay
     * FPS  -- Fast Payment Service.
     * OPS  -- Octopus
     * EPS  -- EPS
     * DCC-VC  -- DCC + Visa Card
     * DCC-MC  -- DCC + Master Card
     * LMS-UP  -- Loyalty + Unionpay
     * LMS-VC  -- Loyalty + Visa Card
     * UPLAN  -- UPLAN
     *
     */
}
