package com.gingersoft.gsa.cloud.login.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.di.component.DaggerRecoverPasswordComponent;
import com.gingersoft.gsa.cloud.login.di.module.RecoverPasswordModule;
import com.gingersoft.gsa.cloud.login.mvp.contract.RecoverPasswordContract;
import com.gingersoft.gsa.cloud.login.mvp.presenter.RecoverPasswordPresenter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import static com.jess.arms.utils.Preconditions.checkNotNull;


public class RecoverPasswordActivity extends BaseActivity<RecoverPasswordPresenter> implements RecoverPasswordContract.View {

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerRecoverPasswordComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .recoverPasswordModule(new RecoverPasswordModule(this))
                .build()
                .inject(this);
    }

//    @Override
//    protected void onCreate(@Nullable Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//            Fade fade = new Fade();
//            fade.setDuration(1000);
//            getWindow().setEnterTransition(fade);
//        }
//    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.layout_recover_password; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        findViewById(R.id.iv_recover_pwd_back).setOnClickListener(v -> killMyself());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
