package com.joe.print.mvp.ui.view;

import android.content.Context;
import android.widget.PopupMenu;
import android.widget.PopupWindow;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import com.joe.print.mvp.print.utils.MyPrintUtils;
import com.joe.print.mvp.ui.adapter.DialogPrinterListAdapter;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.impl.CenterListPopupView;
import com.yanzhenjie.recyclerview.widget.DefaultItemDecoration;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/2/5
 * Time: 16:59
 * Use:選擇打印彈窗
 */
public class SelectPrintDevicePopup extends CenterPopupView {
    private List<PrinterDeviceBean> printerDeviceBeans;
    private OnItemClickListener mOnItemClickListener;
    private PopupWindow.OnDismissListener onDismissListener;

    public SelectPrintDevicePopup(@NonNull Context context, List<PrinterDeviceBean> printerDeviceBeans) {
        super(context);
        this.printerDeviceBeans = printerDeviceBeans;
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout.print_dialog_internet_list;
    }

    @Override
    protected void initPopupContent() {
        RecyclerView mRvPrintList = findViewById(R.id.rv_print_list);
        DialogPrinterListAdapter printListAdapter = new DialogPrinterListAdapter(printerDeviceBeans, getContext());
        mRvPrintList.addItemDecoration(new DefaultItemDecoration(ContextCompat.getColor(getContext(), R.color.line_color)));
        mRvPrintList.setAdapter(printListAdapter);
        printListAdapter.setOnItemClickListener(mOnItemClickListener);
    }

    public SelectPrintDevicePopup setOnItemClickListener(OnItemClickListener mOnItemClickListener) {
        this.mOnItemClickListener = mOnItemClickListener;
        return this;
    }

    public SelectPrintDevicePopup setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        if (onDismissListener != null)
            onDismissListener.onDismiss();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }
}
