package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.WarehousingOrderListModule;
import com.gingersoft.supply_chain.mvp.contract.WarehousingOrderListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WarehousingOrderListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/28/2021 19:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = WarehousingOrderListModule.class, dependencies = AppComponent.class)
public interface WarehousingOrderListComponent {
    void inject(WarehousingOrderListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        WarehousingOrderListComponent.Builder view(WarehousingOrderListContract.View view);

        WarehousingOrderListComponent.Builder appComponent(AppComponent appComponent);

        WarehousingOrderListComponent build();
    }
}