package com.gingersoft.supply_chain.mvp.ui.adapter.binder;

import com.chad.library.adapter.base.BaseBinderAdapter;
import com.gingersoft.supply_chain.mvp.bean.SnInoutBoundRecordBean;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


public class SnInOutRecordAdapter extends BaseBinderAdapter {
    private List<SnInoutBoundRecordBean> hides;
    public void hideRecordList(){
        List<Object> records= getData();
        hides=new ArrayList<>();
        Iterator<Object> iter = records.iterator();
        while (iter.hasNext()) {
            Object record = iter.next();
            if (record instanceof SnInoutBoundRecordBean) {
                hides.add((SnInoutBoundRecordBean) record);
                iter.remove();
            }
        }
        notifyItemRangeRemoved(0,hides.size());
    }

    public boolean canBack(){
        if (hides != null) {
            setList(hides);
            hides.clear();
            hides=null;
            return true;
        }else {
            return  false;
        }

    }

}
