package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.os.UserManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.gsa.cloud.common.core.user.UserConstans;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.common.core.user.info.UserInfo;
import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.ui.animator.CustomAnimation1;
import com.gingersoft.gsa.cloud.ui.animator.CustomAnimation3;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerWarehousingOrderListComponent;
import com.gingersoft.supply_chain.mvp.bean.WarehouseOrderBean;
import com.gingersoft.supply_chain.mvp.content.SupplyShoppingCart;
import com.gingersoft.supply_chain.mvp.contract.WarehousingOrderListContract;
import com.gingersoft.supply_chain.mvp.presenter.WarehousingOrderListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WarehousingOrderListAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.BuyIngredientsFragment;
import com.jess.arms.di.component.AppComponent;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadSir;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodIngredientsFragment.FOOD_INGREDIENTS;


/**
 * Description: 入庫單列表
 */
public class WarehousingOrderListFragment extends BaseSupplyChainFragment<WarehousingOrderListPresenter> implements WarehousingOrderListContract.View, View.OnClickListener {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.rv_second_category)
    RecyclerView rvSecondCategory;
    @BindView(R2.id.smart_fresh)
    SmartRefreshLayout smartRefreshLayout;
    private final static int NEW_WAREHOUSING_ORDER_REQUEST_CODE = 1001;

    public static WarehousingOrderListFragment newInstance() {
        WarehousingOrderListFragment fragment = new WarehousingOrderListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerWarehousingOrderListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_warehousing_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar(supplyTopBar, getString(R.string.str_warehousing_order));
        smartRefreshLayout.setPrimaryColorsId(R.color.trans, R.color.black);
        loadService = LoadSir.getDefault().register(smartRefreshLayout, (Callback.OnReloadListener) v -> {
            mPresenter.pageIndex = 0;
            loadOrderList();
        });
        smartRefreshLayout.setOnRefreshListener(refreshLayout -> loadOrderList());
        smartRefreshLayout.setOnLoadMoreListener(refreshLayout -> {
            mPresenter.pageIndex++;
            loadOrderList();
        });
        supplyTopBar.addRightImageButton(R.drawable.ic_circle_new_food_ingredient, R.id.topbar_right_add_button).setOnClickListener(this);
        loadOrderList();
    }

    private void loadOrderList() {
        mPresenter.getWarehousingOrderList();
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_add_button) {
            //先清空購物車
            SupplyShoppingCart.getInstance().clear();
            //新增入庫單
//            start(BuyIngredientsFragment.newInstance(BuyIngredientsFragment.GET_FOOD_BY_WAREHOUSING_ORDER));
            startForResult(WarehousingOrderDetailsFragment.newInstance(-1, ""), NEW_WAREHOUSING_ORDER_REQUEST_CODE);
        }
    }

    @Override
    public void loadList(WarehousingOrderListAdapter warehousingOrderListAdapter) {
        finishLoad(false);
        setDefaultPageState(warehousingOrderListAdapter);
        warehousingOrderListAdapter.setOnItemClickListener((adapter, view, position) -> start(WarehousingOrderDetailsFragment.newInstance(warehousingOrderListAdapter.getItem(position).getId(), warehousingOrderListAdapter.getItem(position).getStorageType())));
        rvSecondCategory.setAdapter(warehousingOrderListAdapter);
    }
    @Override
    public void setDefaultPageState(WarehousingOrderListAdapter warehousingOrderListAdapter) {
        if (warehousingOrderListAdapter.getItemCount() <= 0) {
            loadService.showCallback(EmptyCallback.class);
        } else {
            loadService.showSuccess();
        }
    }

    @Override
    public void finishLoad(boolean isNoMore) {
        smartRefreshLayout.finishRefresh();
        smartRefreshLayout.finishLoadMore();
        if (isNoMore) {
            smartRefreshLayout.finishLoadMoreWithNoMoreData();
        } else {
            smartRefreshLayout.resetNoMoreData();
        }
    }

    @Override
    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (requestCode == NEW_WAREHOUSING_ORDER_REQUEST_CODE) {
            mPresenter.pageIndex = 0;
            loadOrderList();
        }
    }
}
