package com.gingersoft.gsa.cloud.pay.contract;

import java.util.ArrayList;
import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2020-12-28 10:40
 * @更新時間: 2020-12-28 10:40
 * @描述:支付方式
 */
public class PayMethodContract {

    /**
     * 支付方式
     * <p>
     * 1100:寶達通
     * 1101:支付寶
     * 1103:現金
     * 1021:Google Pay
     * 1102:支付寶HK
     */
    public static final int PAY_METHOD_ID_1 = 1;
    public static final int PAY_METHOD_ID_8 = 8;
    public static final int PAY_METHOD_ID_1103 = 1103;
    public static final int PAY_METHOD_ID_1021 = 1021;
    public static final int PAY_METHOD_ID_1023 = 1023;

    /**
     * Hyweb POS支付方式
     * <p>
     * 1030：N5卡片
     * 1031：N5掃碼
     * 1032：N5八達通
     * 1033：N5美國運通
     */
    public static final int PAY_METHOD_ID_1030 = 1030;
    public static final int PAY_METHOD_ID_1031 = 1031;
    public static final int PAY_METHOD_ID_1032 = 1032;
    public static final int PAY_METHOD_ID_1033 = 1033;
    public static final int[] HYWEB_PAY_METHODS = {PAY_METHOD_ID_1030, PAY_METHOD_ID_1031, PAY_METHOD_ID_1032, PAY_METHOD_ID_1033};

    /**
     * Yedpay POS支付方式
     */
    public static final int PAY_METHOD_ID_1040 = 1040;
    public static final int PAY_METHOD_ID_1041 = 1041;
    public static final int PAY_METHOD_ID_1042 = 1042;
    public static final int[] YEDPAY_PAY_METHODS = {PAY_METHOD_ID_1040, PAY_METHOD_ID_1041, PAY_METHOD_ID_1042};


    /**
     * 獲取所有POS支付方式
     * @return
     */
    public static final List<Integer> getPosPaymethods() {
        List<Integer> POS_PAY_METHODS = new ArrayList<>();
        for (int hywebPayMethod : HYWEB_PAY_METHODS) {
            POS_PAY_METHODS.add(hywebPayMethod);
        }
        for (int yedpayPayMethod : YEDPAY_PAY_METHODS) {
            POS_PAY_METHODS.add(yedpayPayMethod);
        }
        return POS_PAY_METHODS;
    }


    /**
     * 积分支付
     */
    public static final int PAY_METHOD_INTEGRAL = 1105;
}
