package com.gingersoft.gsa.cloud.pay.device.pos.hyweb;

import androidx.fragment.app.FragmentManager;

import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.device.pos.PosCommand;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.AdjustTipRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.RefundRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.RetrievalRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.SaleRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.VoidRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.PrintPaymentStubImpl;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.RefundActionImpl;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.RetrievalActionImpl;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.SaleActionImpl;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.SettlementActionImpl;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.TipsActionImpl;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.imp.VoidActionImpl;

/**
 * @作者: bin
 * @創建時間: 2021-04-14 12:08
 * @更新時間: 2021-04-14 12:08
 * @描述:
 */
public class HywebCommandImp implements PosCommand<PosPay> {

    private static HywebCommandImp sHywebDevice;

    public static HywebCommandImp newInstance() {
        if (sHywebDevice == null) {
            sHywebDevice = new HywebCommandImp();
        }
        return sHywebDevice;
    }

    private HywebCommandImp() {
    }

    @Override
    public void showActionDialog(FragmentManager fragmentManager, RequestParms requestParms) {

    }

    @Override
    public void void0(PosPay posPay) {
        new VoidActionImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.VOID,
                (VoidRequest) posPay.getPosRequest(),
                (GetTxnIdRequest) posPay.getBgRequest(), (PosCallbackListener) (PosCallbackListener) posPay.getCallback(), true)
                .onPosActionBefore();
    }

    @Override
    public void tip(PosPay posPay) {
        new TipsActionImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.TIP, (GetTxnIdRequest) posPay.getBgRequest(),
                (AdjustTipRequest) posPay.getPosRequest(), (PosCallbackListener) posPay.getCallback(), true)
                .onPosActionBefore();
    }

    @Override
    public void retrieval(PosPay posPay) {
        new RetrievalActionImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.RETRIEVAL, posPay.getRetrievalAction(), posPay.getOrderId(),
                (RetrievalRequest) posPay.getPosRequest(), (PosCallbackListener) posPay.getCallback(), false);

    }

    @Override
    public void printStub(PosPay posPay) {
        new PrintPaymentStubImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.PRINT, posPay.getTxnId(),
                (PosCallbackListener) posPay.getCallback(), true)
                .onPosActionBefore();

    }

    @Override
    public void settlement(PosPay posPay) {
        new SettlementActionImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.SETTLEMENT, (PosCallbackListener) posPay.getCallback(), true)
                .onPosActionBefore();
    }

    @Override
    public void pay(PosPay posPay) {
        new SaleActionImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.SALE, (SaleRequest) posPay.getPosRequest(),
                (GetTxnIdRequest) posPay.getBgRequest(), (PosCallbackListener) posPay.getCallback(), true)
                .onPosActionBefore();
    }

    @Override
    public void refund(PosPay posPay) {
        new RefundActionImpl(posPay.getContext(), posPay.getLifecycleView(), PayAction.REFUND, (RefundRequest) posPay.getPosRequest(),
                (GetTxnIdRequest) posPay.getBgRequest(), (PosCallbackListener) posPay.getCallback(), true)
                .onPosActionBefore();

    }

}
