package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.base.utils.view.LayoutToBitmapUtils;
import com.joe.print.R;
import com.gingersoft.gsa.cloud.base.adapter.print.BillAdapter;
import com.gingersoft.gsa.cloud.base.adapter.print.FoodAdapter;
import com.gingersoft.gsa.cloud.base.utils.view.ImageUtils;

import org.jetbrains.annotations.NotNull;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import am.util.printer.PrintDataMaker;
import am.util.printer.PrinterUtils;
import am.util.printer.PrinterWriter;
import am.util.printer.PrinterWriter58mm;
import am.util.printer.PrinterWriter80mm;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by Wyh on 2020/1/9.
 * 送單打印
 */
public class SendPrint implements PrintDataMaker {

    private Context context;
    private int parting = 255;//高度分割值，
    private int width; // 打印的圖片寬度,紙張寬度

    public SendPrint(Context context, int parting, int width) {
        this.context = context;
        this.parting = parting;
        this.width = width;
    }

    @Override
    public List<byte[]> getPrintData(int type) {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer;
            printer = type == PrinterWriter58mm.TYPE_58 ? new PrinterWriter58mm(parting, width) : new PrinterWriter80mm(parting, width);
            printer.setAlignCenter();

            data.add(printer.getDataAndReset());

            View view = initView();
            LayoutToBitmapUtils.layoutView(context, view);//先测量view
            Bitmap bitmap = LayoutToBitmapUtils.loadBitmapFromView(view);//将view轉bitmap


            //壓縮bitmap到指定大小
            bitmap = ImageUtils.zoomDrawable(bitmap, width, bitmap.getHeight());
            ArrayList<byte[]> image1 = PrinterUtils.decodeBitmapToDataList(bitmap, parting);//bitmap转字节码
            data.addAll(image1);

//            String bitmapPath = FileUtils.getExternalFilesDir(context, "Temp") + "tmp_qr.jpg";
//            if (QRCodeUtil.createQRImage(qr, 380, 380, null, bitmapPath)) {
//                ArrayList<byte[]> image2 = printer.getImageByte(bitmapPath);
//                data.addAll(image2);
//            } else {
//                ArrayList<byte[]> image2 = printer
//                        .getImageByte(context.getResources(), R.drawable.ic_printer_qr);
//                data.addAll(image2);
//            }
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.feedPaperCutPartial();
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    private View view;
    private TextView brandName;
    private TextView restaurantName;
    private TextView tableNum;//台號
    private TextView people;//人數
    private TextView orderNum;//單號
    private TextView orderData;
    private RecyclerView rvFood;
    private RecyclerView rvBillAmount;
    private TextView mTvTotalAmount;//總金額
    private TextView checkOutTime;
    private TextView line_food_info;

    @NotNull
    private View initView() {
        if (view == null) {
            view = LinearLayout.inflate(context, R.layout.print_layout_print, null);
            brandName = view.findViewById(R.id.tv_brand_name);
            restaurantName = view.findViewById(R.id.tv_restaurant_name);
            tableNum = view.findViewById(R.id.tv_dining_table_number);
            people = view.findViewById(R.id.tv_people);
            orderNum = view.findViewById(R.id.tv_order_num);
            orderData = view.findViewById(R.id.tv_date);
            rvFood = view.findViewById(R.id.rv_food);
            rvBillAmount = view.findViewById(R.id.rv_bill_amount);
            mTvTotalAmount = view.findViewById(R.id.tv_total_amount);
            checkOutTime = view.findViewById(R.id.tv_checkout_time);
            line_food_info = view.findViewById(R.id.line_food_info);
        }
        List<OrderDetail> foodList = MyOrderManage.getInstance().getOrderFoodList();
        TableBean.DataBean tableBean = OpenTableManage.getDefault().getTableBean();

        tableNum.setText(tableBean.getTableName());
        people.setText(OpenTableManage.getDefault().getPeopleNumber() + "");
        orderData.setText(tableBean.getCreateTime());

        checkOutTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));

        FoodAdapter foodAdapter = new FoodAdapter(foodList);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);

        List<BillingBean> billingBeans = new ArrayList<>();
//        billingBeans.add(new BillingBean("合計", 58.88));
//        billingBeans.add(new BillingBean("10%服務費", 5.08));
//        billingBeans.add(new BillingBean("賬單小數", -0.06));
        if (billingBeans.size() <= 0) {
            line_food_info.setVisibility(View.GONE);
        } else {
            BillAdapter billAdapter = new BillAdapter(billingBeans);
            rvBillAmount.setLayoutManager(new LinearLayoutManager(context));
            rvBillAmount.setAdapter(billAdapter);
        }
        if(OpenTableManage.getDefault().getTableBean() != null) {
            tableNum.setText(OpenTableManage.getDefault().getTableBean().getTableName());
            people.setText(OpenTableManage.getDefault().getPeopleNumber() + "");
        }

        if(MyOrderManage.getInstance().getOrderId() != -1){
            orderNum.setText(MyOrderManage.getInstance().getOrderId() + "");
        }
        BigDecimal totalAmount = new BigDecimal(0);
        for (OrderDetail food : MyOrderManage.getInstance().getOrderFoodList()) {
            totalAmount = MoneyUtil.sum(totalAmount, MoneyUtil.priceCalculation(food.getUnit_price(), food.getNumber()));
        }
        //總金額
        mTvTotalAmount.setText(totalAmount +"");

        //加载条形码
//        ImageView ivBarCode = view.findViewById(R.id.iv_bar_code);
//        ivBarCode.setImageBitmap(BitmapUtil.generateBitmap("12312112131", 2, 450, 150));
        return view;
    }
}
