package com.gingersoft.gsa.cloud.database.bean;

import android.graphics.Color;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Transient;

import java.util.Date;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：
 */
@Entity
public class Modifier {

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long dbid;

    private Long mid;
    /**
     * 食品分类ID
     */
    private Long topId;

    private Long restaurantId;

    private String modifierName;

    private Long seqNo;

    private Double marketPrice;

    private Double price;
    /**
     * 餐盒费
     */
    private Double lunchboxPrice;

    private Long colorId;
    /**
     * 圖片
     */
    private String imageUrl;
    /**
     * 0=顯示, 1=隱藏, 2=暫停
     */
    private Long invisible;
    /**
     * 成本
     */
    private Double cost;
    /**
     * 開始日期
     */
    private Date startDate;
    /**
     * 結束日期
     */
    private Date endDate;
    /**
     * 贊
     */
    private Long like;
    /**
     * 已售
     */
    private Long totalSold;
    /**
     * gspos自定义表中的Id
     */
    private Long majorMainId;
    /**
     * 報表部門分組
     */
    private Long deptId;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 本地对应ID
     */
    private String posFid;
    /**
     * 父级ID
     */
    private String pId;
    /**
     * 細項下有細項時, 是否自動打開細項 0=不開開 1=打開
     */
    private Long autoMod;
    /**
     * 頁面中藍色按鈕有沒有編輯按鈕  (筆的圖按) 0=不可編輯 1=可編輯
     */
    private Long blueEdit;
    /**
     * 相同項目自動合併  0=不自動合併 1=自動合併
     */
    private Long autoMerge;
    /**
     * 自定義細項 (如細項有下一層, 當層的自定義細項會失效) 0=否 1=是
     */
    private Long customMsg;
    /**
     * 是否組別  1 为组别
     */
    private Long isParent;
    /**
     * 食品名称1
     */
    private String modifierName1;
    /**
     * 食品名称2
     */
    private String modifierName2;
    /**
     * 金額=-994時, 取這個數值乘主項金額
     */
    private Double multiple;
    /**
     * 打印設定
     */
    private String printSet;
    /**
     * 廚房打印設定
     */
    private String ktSetting;
    /**
     * 多選
     */
    private Long modComm;
    /**
     * 口味
     */
    private Long modTaste;
    /**
     * 訊息
     */
    private Long modMsg;
    /**
     * TRUE=追單, FALSE=不處理
     */
    private Long ktFireCourse;
    /**
     * 是否参与折扣#1:可折扣
     */
    private Long ableDisCount;
    /**
     * 打印到帳單
     */
    private Long printToBill;
    /**
     * 廚房單打印主項
     */
    private Long ktPrintMainItem;
    /**
     * 廚房單顯示單價
     */
    private Long ktShowPrice;
    /**
     * 廚房打印顏色
     */
    private Long ktFont;
    /**
     * 0:新增；1：修改：2刪除
     */
    private Long conditions;
    /**
     * 是否同步 0：否 1：是
     */
    private Long isRt;
    /**
     * 隱藏
     */
    private Byte visible;
    /**
     * 是否删除：0正常，1删除
     */
    private Long deletes;
    /**
     * 是否參與會員喜好統計 0 參與  1 不參與
     */
    private Long isStatistic;


    /**
     * 自定義字段
     */
    @Transient
    /**當前食品ID*/
    private long fid;
    @Transient
    /**選中數量*/
    private int number;
    @Transient
    /**背景顏色*/
    private int bgColor = Color.parseColor("#069683");
    @Transient
    /**字體顏色*/
    private int fontColor = Color.parseColor("#FFFFFF");
    @Transient
    /**最大選中數*/
    private int maxNumber = 99;
    @Transient
    /**是否選中*/
    private boolean selected;
    @Transient
    /**是否細項組返回按鈕*/
    private boolean isReturn;


    @Generated(hash = 869528398)
    public Modifier(Long dbid, Long mid, Long topId, Long restaurantId,
                    String modifierName, Long seqNo, Double marketPrice, Double price,
                    Double lunchboxPrice, Long colorId, String imageUrl, Long invisible,
                    Double cost, Date startDate, Date endDate, Long like, Long totalSold,
                    Long majorMainId, Long deptId, String createBy, Date createTime,
                    String updateBy, Date updateTime, String posFid, String pId,
                    Long autoMod, Long blueEdit, Long autoMerge, Long customMsg,
                    Long isParent, String modifierName1, String modifierName2,
                    Double multiple, String printSet, String ktSetting, Long modComm,
                    Long modTaste, Long modMsg, Long ktFireCourse, Long ableDisCount,
                    Long printToBill, Long ktPrintMainItem, Long ktShowPrice, Long ktFont,
                    Long conditions, Long isRt, Byte visible, Long deletes,
                    Long isStatistic) {
        this.dbid = dbid;
        this.mid = mid;
        this.topId = topId;
        this.restaurantId = restaurantId;
        this.modifierName = modifierName;
        this.seqNo = seqNo;
        this.marketPrice = marketPrice;
        this.price = price;
        this.lunchboxPrice = lunchboxPrice;
        this.colorId = colorId;
        this.imageUrl = imageUrl;
        this.invisible = invisible;
        this.cost = cost;
        this.startDate = startDate;
        this.endDate = endDate;
        this.like = like;
        this.totalSold = totalSold;
        this.majorMainId = majorMainId;
        this.deptId = deptId;
        this.createBy = createBy;
        this.createTime = createTime;
        this.updateBy = updateBy;
        this.updateTime = updateTime;
        this.posFid = posFid;
        this.pId = pId;
        this.autoMod = autoMod;
        this.blueEdit = blueEdit;
        this.autoMerge = autoMerge;
        this.customMsg = customMsg;
        this.isParent = isParent;
        this.modifierName1 = modifierName1;
        this.modifierName2 = modifierName2;
        this.multiple = multiple;
        this.printSet = printSet;
        this.ktSetting = ktSetting;
        this.modComm = modComm;
        this.modTaste = modTaste;
        this.modMsg = modMsg;
        this.ktFireCourse = ktFireCourse;
        this.ableDisCount = ableDisCount;
        this.printToBill = printToBill;
        this.ktPrintMainItem = ktPrintMainItem;
        this.ktShowPrice = ktShowPrice;
        this.ktFont = ktFont;
        this.conditions = conditions;
        this.isRt = isRt;
        this.visible = visible;
        this.deletes = deletes;
        this.isStatistic = isStatistic;
    }

    @Generated(hash = 385685553)
    public Modifier() {
    }


    public Long getDbid() {
        return dbid;
    }

    public Long getMid() {
        return mid;
    }

    public long getTopId() {
        return topId;
    }

    public Long getRestaurantId() {
        return restaurantId;
    }

    public String getModifierName() {
        return modifierName;
    }

    public Long getSeqNo() {
        return seqNo;
    }

    public Double getMarketPrice() {
        return marketPrice;
    }

    public Double getPrice() {
        return price;
    }

    public Double getLunchboxPrice() {
        return lunchboxPrice;
    }

    public Long getColorId() {
        return colorId;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public Long getInvisible() {
        return invisible;
    }

    public Double getCost() {
        return cost;
    }

    public Date getStartDate() {
        return startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public Long getLike() {
        return like;
    }

    public Long getTotalSold() {
        return totalSold;
    }

    public Long getMajorMainId() {
        return majorMainId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public String getCreateBy() {
        return createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public String getPosFid() {
        return posFid;
    }

    public String getpId() {
        return pId;
    }

    public Long getAutoMod() {
        return autoMod;
    }

    public Long getBlueEdit() {
        return blueEdit;
    }

    public Long getAutoMerge() {
        return autoMerge;
    }

    public Long getCustomMsg() {
        return customMsg;
    }

    public boolean isParent() {
        if (isParent == null)
            return false;
        return isParent == 1 ? true : false;
    }

    public String getModifierName1() {
        return modifierName1;
    }

    public String getModifierName2() {
        return modifierName2;
    }

    public Double getMultiple() {
        return multiple;
    }

    public String getPrintSet() {
        return printSet;
    }

    public String getKtSetting() {
        return ktSetting;
    }

    public Long getModComm() {
        return modComm;
    }

    public Long getModTaste() {
        return modTaste;
    }

    public Long getModMsg() {
        return modMsg;
    }

    public Long getKtFireCourse() {
        return ktFireCourse;
    }

    public Long getAbleDisCount() {
        return ableDisCount;
    }

    public Long getPrintToBill() {
        return printToBill;
    }

    public Long getKtPrintMainItem() {
        return ktPrintMainItem;
    }

    public Long getKtShowPrice() {
        return ktShowPrice;
    }

    public Long getKtFont() {
        return ktFont;
    }

    public Long getConditions() {
        return conditions;
    }

    public Long getIsRt() {
        return isRt;
    }

    public Byte getVisible() {
        return visible;
    }

    public Long getDeletes() {
        return deletes;
    }

    public Long getIsStatistic() {
        return isStatistic;
    }

    public long getFid() {
        return fid;
    }

    public int getNumber() {
        return number;
    }

    public int getBgColor() {
        return bgColor;
    }

    public int getFontColor() {
        return fontColor;
    }

    public int getMaxNumber() {
        return maxNumber;
    }

    public boolean isSelected() {
        return selected;
    }

    public boolean isReturn() {
        return isReturn;
    }

    public void setDbid(Long dbid) {
        this.dbid = dbid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }

    public void setTopId(Long topId) {
        this.topId = topId;
    }

    public void setRestaurantId(Long restaurantId) {
        this.restaurantId = restaurantId;
    }

    public void setModifierName(String modifierName) {
        this.modifierName = modifierName;
    }

    public void setSeqNo(Long seqNo) {
        this.seqNo = seqNo;
    }

    public void setMarketPrice(Double marketPrice) {
        this.marketPrice = marketPrice;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setLunchboxPrice(Double lunchboxPrice) {
        this.lunchboxPrice = lunchboxPrice;
    }

    public void setColorId(Long colorId) {
        this.colorId = colorId;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setInvisible(Long invisible) {
        this.invisible = invisible;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setLike(Long like) {
        this.like = like;
    }

    public void setTotalSold(Long totalSold) {
        this.totalSold = totalSold;
    }

    public void setMajorMainId(Long majorMainId) {
        this.majorMainId = majorMainId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setPosFid(String posFid) {
        this.posFid = posFid;
    }

    public void setpId(String pId) {
        this.pId = pId;
    }

    public void setAutoMod(Long autoMod) {
        this.autoMod = autoMod;
    }

    public void setBlueEdit(Long blueEdit) {
        this.blueEdit = blueEdit;
    }

    public void setAutoMerge(Long autoMerge) {
        this.autoMerge = autoMerge;
    }

    public void setCustomMsg(Long customMsg) {
        this.customMsg = customMsg;
    }

    public void setIsParent(Long isParent) {
        this.isParent = isParent;
    }

    public void setModifierName1(String modifierName1) {
        this.modifierName1 = modifierName1;
    }

    public void setModifierName2(String modifierName2) {
        this.modifierName2 = modifierName2;
    }

    public void setMultiple(Double multiple) {
        this.multiple = multiple;
    }

    public void setPrintSet(String printSet) {
        this.printSet = printSet;
    }

    public void setKtSetting(String ktSetting) {
        this.ktSetting = ktSetting;
    }

    public void setModComm(Long modComm) {
        this.modComm = modComm;
    }

    public void setModTaste(Long modTaste) {
        this.modTaste = modTaste;
    }

    public void setModMsg(Long modMsg) {
        this.modMsg = modMsg;
    }

    public void setKtFireCourse(Long ktFireCourse) {
        this.ktFireCourse = ktFireCourse;
    }

    public void setAbleDisCount(Long ableDisCount) {
        this.ableDisCount = ableDisCount;
    }

    public void setPrintToBill(Long printToBill) {
        this.printToBill = printToBill;
    }

    public void setKtPrintMainItem(Long ktPrintMainItem) {
        this.ktPrintMainItem = ktPrintMainItem;
    }

    public void setKtShowPrice(Long ktShowPrice) {
        this.ktShowPrice = ktShowPrice;
    }

    public void setKtFont(Long ktFont) {
        this.ktFont = ktFont;
    }

    public void setConditions(Long conditions) {
        this.conditions = conditions;
    }

    public void setIsRt(Long isRt) {
        this.isRt = isRt;
    }

    public void setVisible(Byte visible) {
        this.visible = visible;
    }

    public void setDeletes(Long deletes) {
        this.deletes = deletes;
    }

    public void setIsStatistic(Long isStatistic) {
        this.isStatistic = isStatistic;
    }

    public void setFid(long fid) {
        this.fid = fid;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public void setMaxNumber(int maxNumber) {
        this.maxNumber = maxNumber;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setReturn(boolean aReturn) {
        isReturn = aReturn;
    }

    public String getPId() {
        return this.pId;
    }

    public void setPId(String pId) {
        this.pId = pId;
    }

    public Long getIsParent() {
        return this.isParent;
    }
}
