package com.gingersoft.gsa.cloud.table.app.payment;

import com.etps.aca.lib.constant.Constant;
import com.gingersoft.gsa.cloud.base.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.table.app.payment.bean.AdjustTipRespose;
import com.gingersoft.gsa.cloud.table.app.payment.bean.RefundRespose;
import com.gingersoft.gsa.cloud.table.app.payment.bean.RetrievalRespose;
import com.gingersoft.gsa.cloud.table.app.payment.bean.SaleRespose;
import com.gingersoft.gsa.cloud.table.app.payment.bean.SettlementRespose;
import com.gingersoft.gsa.cloud.table.app.payment.bean.VoidRespose;
import com.gingersoft.gsa.cloud.table.app.payment.contract.IN5Callback;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-11-01
 * 修订历史：2019-11-01
 * 描述：
 */
public final class N5CallbackManage {

    private Map<Object, IN5Callback> mActionMap = new HashMap<>();
    private Map<String, Boolean> mCallbackRecordMap = new HashMap<>();

    private static N5CallbackManage sDefaultN5Callback;

    public static N5CallbackManage getInstance() {
        if (sDefaultN5Callback == null) {
            synchronized (N5CallbackManage.class) {
                if (sDefaultN5Callback == null) {
                    sDefaultN5Callback = new N5CallbackManage();
                }
            }
        }
        return sDefaultN5Callback;
    }

    public void post(Object className, String response, String action) {

        if (className == null || !mActionMap.containsKey(className)) {
            return;
        }

        Iterator<Object> iterator = mActionMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (key != null && key == className) {
                IN5Callback callback = mActionMap.get(key);
                switch (action) {
                    case Constant.EVENT.NAME.SALE_RESP:
                        SaleRespose saleRespose = GsonUtils.GsonToBean(response, SaleRespose.class);
                        callback.onSaleCall(saleRespose);
                        //回調記錄這裡支付使用操作類型+交易ID作為key，防止回調記錄被重疊
                        String saleCallKey = Constant.EVENT.NAME.SALE + "_" + saleRespose.getTXN_ID();
                        mCallbackRecordMap.put(saleCallKey, true);
                        break;
                    case Constant.EVENT.NAME.VOID_RESP:
                        VoidRespose voidRespose = GsonUtils.GsonToBean(response, VoidRespose.class);
                        callback.onVoidCall(voidRespose);
                        //回調記錄這裡使用取消操作類型+交易ID作為key，防止回調記錄被重疊
                        String voidCallKey = Constant.EVENT.NAME.VOID + "_" + voidRespose.getTXN_ID();
                        mCallbackRecordMap.put(voidCallKey, true);
                        break;
                    case Constant.EVENT.NAME.REFUND_RESP:
                        RefundRespose refundRespose = GsonUtils.GsonToBean(response, RefundRespose.class);
                        callback.onRefundCall(refundRespose);
                        //回調記錄這裡使用退款操作類型+交易ID作為key，防止回調記錄被重疊
                        String refundCallKey = Constant.EVENT.NAME.REFUND + "_" + refundRespose.getTXN_ID();
                        mCallbackRecordMap.put(refundCallKey, true);
                        break;
                    case Constant.EVENT.NAME.ADJUST_RESP:
                        AdjustTipRespose adjustTipRespose = GsonUtils.GsonToBean(response, AdjustTipRespose.class);
                        callback.onAdjustCall(adjustTipRespose);
                        //回調記錄這裡使用支付操作類型+交易ID作為key，防止回調記錄被重疊
                        String tipCallKey = Constant.EVENT.NAME.ADJUST + "_" + adjustTipRespose.getTXN_ID();
                        mCallbackRecordMap.put(tipCallKey, true);
                        break;
                    case Constant.EVENT.NAME.PRINT_RESP:
                        callback.onPrinterCall(response);
                        mCallbackRecordMap.put(Constant.EVENT.NAME.PRINT, true);
                        break;
                    case "RETRIEVAL_RESP":
                        RetrievalRespose retrievalRespose = GsonUtils.GsonToBean(response, RetrievalRespose.class);
                        callback.onRetrievalCall(retrievalRespose);
                        //回調記錄這裡使用支付操作類型+交易ID作為key，防止回調記錄被重疊
                        String retrievalCallKey = "RETRIEVAL" + "_" + retrievalRespose.getTXN_ID();
                        mCallbackRecordMap.put(retrievalCallKey, true);
                        break;
                    case "SETTLE_RESP":
                        callback.onSettleCall(GsonUtils.GsonToBean(response, SettlementRespose.class));
                        mCallbackRecordMap.put("SETTLE", true);
                        break;
                }
            }
        }
    }

    public void register(Object className, IN5Callback callback) {
        if (className == null) {
            return;
        }
        synchronized (this) {
            mActionMap.put(className, callback);
        }
    }

    public void unregister(Object className) {
        if (className == null) {
            return;
        }
        synchronized (this) {
            mActionMap.remove(className);
        }
    }

    public Map<String, Boolean> getCallbackRecordMap() {
        return mCallbackRecordMap;
    }
}
