package com.gingersoft.gsa.cloud.ui.bean.view;

import com.qmuiteam.qmui.widget.section.QMUISection.Model;

import java.util.Objects;

public class SectionImageItem implements Model<SectionImageItem> {
    private int image;
    private String text;

    public SectionImageItem(int image, String text) {
        this.image = image;
        this.text = text;
    }

    public String getText() {
        return text;
    }

    public int getImage() {
        return image;
    }

    @Override
    public SectionImageItem cloneForDiff() {
        return new SectionImageItem(getImage(), getText());
    }

    @Override
    public boolean isSameItem(SectionImageItem other) {
        return Objects.equals(text, other.text);
    }

    @Override
    public boolean isSameContent(SectionImageItem other) {
        return true;
    }
}
