package com.gingersoft.gsa.other_order_mode.data.model.bean

import com.gingersoft.gsa.other_order_mode.R


class BtnBuilder {
    companion object {
        val sureBtn = 0
        val cancelBtn = 1
        val printBtn = 2
        val logisticsBtn = 3
        val assignDeliveryBtn = 4
        val closingBtn = 5
        val ProductionCompletedBtn = 6
    }

    class BtnBean(val type: Int, val btnContent: String, val btnColor: Int, val btnImg: Int)

    fun getSureBtn(): BtnBean {
        return BtnBean(sureBtn, "確認訂單", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getProductionCompletedBtn(): BtnBean {
        return BtnBean(ProductionCompletedBtn, "製作完成", R.color.other_order_details_sure_btn_color, R.drawable.ic_sure)
    }

    fun getCancelBtn(): BtnBean {
        return BtnBean(cancelBtn, "取消訂單", R.color.other_order_details_cancel_btn_color, R.drawable.ic_cancel)
    }

    fun getPrintBtn(): BtnBean {
        return BtnBean(printBtn, "打印訂單", R.color.other_order_details_print_btn_color, R.drawable.ic_print)
    }

    fun getLogisticsBtn(): BtnBean {
        return BtnBean(logisticsBtn, "取消物流", R.color.other_order_details_cancel_logistics_btn_color, R.drawable.ic_logistics)
    }

    fun getAssignDeliveryBtn(): BtnBean {
        return BtnBean(assignDeliveryBtn, "指派送貨", R.color.other_order_details_sure_btn_color, R.drawable.ic_deliveryman)
    }

    fun getClosingBtn(): BtnBean {
        return BtnBean(closingBtn, "結賬", R.color.other_order_details_cancel_btn_color, R.drawable.ic_closing)
    }


}
