/*
 * Decompiled with CFR 0.152.
 */
package com.hyweb.n5.lib.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.hyweb.n5.lib.exception.NoInitReaderException;
import com.hyweb.n5.server.aidl.IOnReadBlockCallback;
import com.hyweb.n5.server.aidl.IOnReadCallback;
import com.hyweb.n5.server.aidl.IOnWriteBlockCallback;
import com.hyweb.n5.server.aidl.IReaderService;
import java.util.List;

public class ReaderUtil {
    private static IReaderService mReaderService;
    private static ServiceConnection mServiceConnection;

    static {
        mServiceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                mReaderService = null;
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                mReaderService = IReaderService.Stub.asInterface(service);
            }
        };
    }

    private static void bindReaderService(Context context) {
        Intent implicitIntent;
        Context localContext = context.getApplicationContext();
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent = new Intent("com.hyweb.n5.server.aidl.IReaderService"), 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        localContext.bindService(explicitIntent, mServiceConnection, 1);
    }

    public static void initReader(Context context) throws NoInitReaderException, RemoteException {
        ReaderUtil.bindReaderService(context);
        if (mReaderService == null) {
            throw new NoInitReaderException();
        }
    }

    public static void registerReadCallback(IOnReadCallback cb) throws RemoteException {
        mReaderService.registerReadCallback(cb);
    }

    public static void unregisterReadCallback(IOnReadCallback cb) throws RemoteException {
        mReaderService.unregisterReadCallback(cb);
    }

    public static void registerReadBlkCallback(IOnReadBlockCallback cb) throws RemoteException {
        mReaderService.registerReadBlkCallback(cb);
    }

    public static void unregisterReadBlkCallback(IOnReadBlockCallback cb) throws RemoteException {
        mReaderService.unregisterReadBlkCallback(cb);
    }

    public static void registerWriteBlkCallback(IOnWriteBlockCallback cb) throws RemoteException {
        mReaderService.registerWriteBlkCallback(cb);
    }

    public static void unregisterWriteBlkCallback(IOnWriteBlockCallback cb) throws RemoteException {
        mReaderService.unregisterWriteBlkCallback(cb);
    }

    public static void searchCard(int timeout) throws RemoteException {
        mReaderService.searchCard(timeout);
    }

    public static void stopSearch() throws RemoteException {
        mReaderService.stopSearch();
    }

    public static String readUid() throws RemoteException {
        return mReaderService.readUid();
    }

    public static int authority(int blkNo, int keyType, String pwd, String uid) throws RemoteException {
        return mReaderService.authority(blkNo, keyType, pwd, uid);
    }

    public static void readBlock(int operType, int blkNo, IOnReadBlockCallback callback) throws RemoteException {
        mReaderService.readBlock(operType, blkNo, callback);
    }

    public static void writeBlock(int operType, int blkNo, String blkData) throws RemoteException {
        mReaderService.writeBlock(operType, blkData, blkNo);
    }
}

