package com.joe.print.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Switch;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.ui.utils.DialogUtils;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.joe.print.R;
import com.joe.print.R2;
import com.joe.print.di.component.DaggerPrintAddCurrencyComponent;
import com.joe.print.di.module.PrintAddCurrencyModule;
import com.joe.print.mvp.contract.PrintAddCurrencyContract;
import com.joe.print.mvp.presenter.PrintAddCurrencyPresenter;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


public class PrintAddCurrencyActivity extends BaseActivity<PrintAddCurrencyPresenter> implements PrintAddCurrencyContract.View, View.OnClickListener {
    @BindView(R2.id.add_printer_currency_topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.print_currency_table_mode)
    TextView tvTableMode;
    @BindView(R2.id.tv_currency_add_food_color)
    TextView tvFoodColor;
    @BindView(R2.id.tv_currency_add_food_item_color)
    TextView tvFoodItemColor;
    @BindView(R2.id.tv_currency_add_food_font_size)
    TextView tvFoodFontSize;
    @BindView(R2.id.tv_currency_add_food_item_font_size)
    TextView tvFoodFontThickness;
    @BindView(R2.id.switch_currency_add_food_font_thickness)
    Switch switchFoodFontThickness;
    @BindView(R2.id.switch_currency_add_food_item_font_thickness)
    Switch switchFoodItemFontThickness;
    @BindView(R2.id.switch_currency_add_food_italic)
    Switch switchFoodItalic;
    @BindView(R2.id.switch_currency_add_food_item_italic)
    Switch switchFoodItemItalic;
    @BindView(R2.id.switch_currency_add_color_flip)
    Switch switchColorFlip;

    private PrintCurrencyBean printCurrencyBean;

    private int typePosition = 1;//1堂食，2外賣
    private int foodColorPosition = 0;//食品顏色 0黑色，1紅色，3 綠色
    private int foodItemColorPosition = 0;//細項顔色  0 黑色 1 紅色

    private boolean isUpdate = false;//true 為修改，false 為新增

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerPrintAddCurrencyComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .printAddCurrencyModule(new PrintAddCurrencyModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_print_add_currency; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        if (printCurrencyBean != null) {
            isUpdate = true;
            typePosition = printCurrencyBean.getType();
            foodColorPosition = printCurrencyBean.getFoodComplexion();
            foodItemColorPosition = printCurrencyBean.getModifierComplexion();

            setTableType();
            setFoodColor();
            setFoodItemColor();
            tvFoodFontSize.setText(printCurrencyBean.getFoodFont());
            tvFoodFontThickness.setText(printCurrencyBean.getModifierFont());
            switchFoodFontThickness.setChecked(printCurrencyBean.getFoodIsBold() == 1);
            switchFoodItemFontThickness.setChecked(printCurrencyBean.getModifierIsBold() == 1);
            switchFoodItalic.setChecked(printCurrencyBean.getFoodIsItalic() == 1);
            switchFoodItemItalic.setChecked(printCurrencyBean.getModifierIsItalic() == 1);
            switchColorFlip.setChecked(printCurrencyBean.getNumberIsFlip() == 1);
        } else {
            isUpdate = false;
            //設置默認值
            setTableType();
            setFoodColor();
            setFoodItemColor();
        }
    }

    private void setFoodItemColor() {
        if (foodItemColorPosition == 0) {
            tvFoodItemColor.setText("黑色");
        } else if (foodItemColorPosition == 1) {
            tvFoodItemColor.setText("綠色");
        } else if (foodItemColorPosition == 2) {
            tvFoodItemColor.setText("紅色");
        }
    }

    private void setTableType() {
        tvTableMode.setText(typePosition == 1 ? "堂食" : "外送");
    }

    private void setFoodColor() {
        if (foodColorPosition == 0) {
            tvFoodColor.setText("黑色");
        } else if (foodColorPosition == 2) {
            tvFoodColor.setText("紅色");
        } else if (foodColorPosition == 1) {
            tvFoodColor.setText("綠色");
        }
    }

    @Override
    public void initIntent() {
        printCurrencyBean = (PrintCurrencyBean) getIntent().getSerializableExtra("printCurrencyBean");
    }

    @Override
    public void initTopBar() {
        mTopBar.setTitle("通用打印設置");
        mTopBar.setBackgroundColor(getResources().getColor(R.color.theme_color));
        mTopBar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> finish());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    private void addCurrencyPrinter() {
        if (printCurrencyBean == null) {
            printCurrencyBean = new PrintCurrencyBean();
            printCurrencyBean.setRestaurantId(RestaurantInfoManager.newInstance().getRestaurantId());
        }
        printCurrencyBean.setUid(UserContext.newInstance().getMemberId());
        printCurrencyBean.setType(typePosition);
        printCurrencyBean.setFoodComplexion(foodColorPosition);
        printCurrencyBean.setModifierComplexion(foodItemColorPosition);
        printCurrencyBean.setFoodFont(tvFoodFontSize.getText().toString());
        printCurrencyBean.setModifierFont(tvFoodFontThickness.getText().toString());
        printCurrencyBean.setFoodIsBold(switchFoodFontThickness.isChecked() ? 1 : 2);
        printCurrencyBean.setModifierIsBold(switchFoodItemFontThickness.isChecked() ? 1 : 2);
        printCurrencyBean.setFoodIsItalic(switchFoodItalic.isChecked() ? 1 : 2);
        printCurrencyBean.setModifierIsItalic(switchFoodItemItalic.isChecked() ? 1 : 2);
        printCurrencyBean.setNumberIsFlip(switchColorFlip.isChecked() ? 1 : 2);
        mPresenter.addCurrencyPresenter(printCurrencyBean, isUpdate);
    }

    private void showSelectType() {
        List<String> types = new ArrayList<>();
        types.add("堂食");
        types.add("外送");
        DialogUtils.showSelectPopop(this, types, "餐檯模式", typePosition, i -> {
            typePosition = i + 1;
            setTableType();
        });
    }

    private void showSelectFoodColor() {
        List<String> types = new ArrayList<>();
        types.add("黑色");
        types.add("紅色");
//        types.add("綠色");
        DialogUtils.showSelectPopop(this, types, "食品顏色", 0, i -> {
            if (i == 1) {
                foodColorPosition = 2;
            } else {
                foodColorPosition = i;
            }
            setFoodColor();
        });
    }

    private void showSelectFoodItemColor() {
        List<String> types = new ArrayList<>();
        types.add("黑色");
        types.add("紅色");
        DialogUtils.showSelectPopop(this, types, "細項顏色", foodItemColorPosition, i -> {
            if (i == 1) {
                foodItemColorPosition = 2;
            } else {
                foodItemColorPosition = i;
            }
            setFoodItemColor();
        });
    }

    private void showSelectFoodFontSize(TextView view) {
        List<String> fontSize = Arrays.asList("預設", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30");
        DialogUtils.showSelectPopop(this, fontSize, "字體大小", 0, i -> view.setText(fontSize.get(i)));
    }

    @OnClick({R2.id.printer_add_currency, R2.id.layout_currency_add_table_mode, R2.id.layout_currency_add_food_color, R2.id.layout_currency_add_food_item_color, R2.id.layout_currency_add_food_font_size, R2.id.layout_currency_add_food_item_font_size})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.printer_add_currency) {
            //添加通用打印設置
            addCurrencyPrinter();
        } else if (viewId == R.id.layout_currency_add_table_mode) {
            //選擇模式
            showSelectType();
        } else if (viewId == R.id.layout_currency_add_food_color) {
            //食品顏色
            showSelectFoodColor();
        } else if (viewId == R.id.layout_currency_add_food_item_color) {
            //細項顏色
            showSelectFoodItemColor();
        } else if (viewId == R.id.layout_currency_add_food_font_size) {
            //食品字體大小
            showSelectFoodFontSize(tvFoodFontSize);
        } else if (viewId == R.id.layout_currency_add_food_item_font_size) {
            //細項字體大小
            showSelectFoodFontSize(tvFoodFontThickness);
        }
    }

    @Override
    public void addSuccess(boolean isSuccess) {
        if (isSuccess) {
            ToastUtils.show(mContext, "保存成功");
            finish();
        } else {
            ToastUtils.show(mContext, "保存失敗");
        }
    }


}
