package com.gingersoft.supply_chain.mvp.bean;

import java.util.List;
import java.util.Objects;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/30
 * Time: 10:19
 * Use: 食材列表展示數據
 */
public class BuyIngredientsBean {
    /**
     * 分類id
     */
    public int id;
    /**
     * 分類名
     */
    public String categoryName;
    /**
     * 分類的id
     */
    public int parentId;
    /**
     * 食材信息
     */
    public List<PurchaseFoodBean> purchaseFoodList;

    public BuyIngredientsBean() {
    }

    public BuyIngredientsBean(int id, String categoryName, int parentId) {
        this.id = id;
        this.categoryName = categoryName;
        this.parentId = parentId;
    }

    public BuyIngredientsBean(int id, String categoryName, int parentId, List<PurchaseFoodBean> purchaseFoodList) {
        this.id = id;
        this.categoryName = categoryName;
        this.parentId = parentId;
        this.purchaseFoodList = purchaseFoodList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuyIngredientsBean that = (BuyIngredientsBean) o;
        return id == that.id &&
                parentId == that.parentId &&
                Objects.equals(categoryName, that.categoryName);
    }

    @Override
    public String toString() {
        return "BuyIngredientsBean{" +
                "id=" + id +
                ", categoryName='" + categoryName + '\'' +
                ", parentId=" + parentId +
                ", purchaseFoodList=" + purchaseFoodList +
                '}';
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, categoryName, parentId);
    }
}
