package com.gingersoft.supply_chain.mvp.bean;

import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/24
 * Time: 14:14
 * Use: 入庫接口上傳實體類
 */
@Data
public class OrderWareHouseBean {
    private int status;
    private int orderId;
    private List<String> encodeFoodNos;
    private PurchaseWarehousingOrder purchaseWarehousingOrder;
    private List<PurchaseWarehousingOrderDetail> purchaseWarehousingOrderDetailsTOS;
    @Data
    public static class PurchaseWarehousingOrder {
        /**
         * 訂單圖片，多張，用逗號分隔
         */
        private String files;
        private String remarks;
        private double totalPrice;

        private int brandId;
        private int restaurantId;
    }

    @Data
    public static class PurchaseWarehousingOrderDetail {
        private int orderDetailsId;
        private int purchaseFoodId;
        private int foodQuantity;
        private double foodPrice;
        private double totalPrice;
        /**
         * 主單位名稱
         */
        private String basicUnitName;
        /**
         * 主單位內容
         */
        private double basicUnitValue;
        /**
         * 副單位
         */
        private WareHousingUnitBean purchaseWarehousingUnit;
        /**
         * sn碼
         */
        private List<PurchaseFoodEncodeSn> purchaseFoodEncodeSn;
    }
}
