package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.table.mvp.contract.OrderDetailContract;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.functions.Function;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/13/2020 14:29
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderDetailModel extends BaseModel implements OrderDetailContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderDetailModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getOrderDetailItem(long orderId) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .getOrderDetail(orderId);
    }

    @Override
    public Observable<BaseResult> cancelOrder(long orderId) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .cancelOrder(orderId)
                .flatMap(new Function<BaseResult, Observable<BaseResult>>() {
                    @Override
                    public Observable<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return getOrderDetailItem(orderId);
                        }
                        return Observable.just(info);
                    }
                });
    }
}