package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;

import com.gingersoft.gsa.cloud.common.core.discount.MemberCoupon;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseDialogFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.BasePresenter;
import com.qmuiteam.qmui.arch.QMUIFragmentPagerAdapter;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

/**
 * @作者: bin
 * @創建時間: 2021-04-02 17:14
 * @更新時間: 2021-04-02 17:14
 * @描述:
 */
public class DiscountDialogFragment extends BaseDialogFragment<BasePresenter> {

    private final String TAG = "DiscountFragment";

    @BindView(R2.id.tabSegment)
    QMUITabSegment tabSegment;
    @BindView(R2.id.contentViewPager)
    ViewPager contentViewPager;
    @BindView(R2.id.ll_container)
    QMUILinearLayout llContainer;

    private CouponFragment couponFragment;
    private NomalDiscountFragment billDiscountFragment;

    private List<String> mTabTitles = new ArrayList<>();
    private int mCurrentPageIndex = 0;

    public static DiscountDialogFragment newInstance() {
        DiscountDialogFragment fragment = new DiscountDialogFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        this.getDialog().setCanceledOnTouchOutside(false);
        return inflater.inflate(R.layout.table_dialog_discout, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        mWindow.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        WindowManager.LayoutParams lp = mWindow.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.6);
        lp.gravity = Gravity.BOTTOM;
        lp.windowAnimations = android.R.style.Animation_InputMethod;
        mWindow.setAttributes(lp);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        float mShadowAlpha = 0.25f;
        int mShadowElevationDp = 14;
        llContainer.setRadiusAndShadow(15, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        initTabAndPager();
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    private void initTabAndPager() {
        MemberInfo memberInfo = DoshokuOrder.getInstance().getMemberInfo();
        QMUIFragmentPagerAdapter pagerAdapter = new QMUIFragmentPagerAdapter(getChildFragmentManager()) {
            @Override
            public Fragment createFragment(int position) {
                switch (position) {
                    case 1:
                        if (couponFragment != null) {
                            return couponFragment;
                        }
                        couponFragment = CouponFragment.newInstance();
                        couponFragment.setOnCouponItemClickListener(new CouponFragment.OnCouponItemClickListener() {
                            @Override
                            public void onItemClick(MemberCoupon item, int position) {
                                if (onDiscountItemClickListener != null) {
                                    onDiscountItemClickListener.onCouponClick(item, position);
                                }
                            }
                        });
                        return couponFragment;
                    default:
                        if (billDiscountFragment != null) {
                            return billDiscountFragment;
                        }
                        billDiscountFragment = NomalDiscountFragment.newInstance();
                        billDiscountFragment.setOnDiscountItemClickListener(new NomalDiscountFragment.OnBillDiscountItemClickListener() {
                            @Override
                            public void onItemClick(Discount item, int position) {
                                if (onDiscountItemClickListener != null) {
                                    onDiscountItemClickListener.onBillDiscountClick(item, position);
                                }
                            }
                        });
                        return billDiscountFragment;
                }
            }

            @Override
            public int getCount() {
                return mTabTitles.size();
            }

            @Override
            public CharSequence getPageTitle(int position) {
                return mTabTitles.get(position);
            }
        };
        QMUITabBuilder builder = tabSegment.tabBuilder();

        mTabTitles.add("折扣");
        QMUITab tab1 = builder
                .setText(mTabTitles.get(0))
                .build(_mActivity);
        tabSegment.addTab(tab1);

        if (memberInfo != null) {
            mTabTitles.add("優惠券");
            QMUITab tab2 = builder
                    .setText(mTabTitles.get(1))
                    .build(_mActivity);
            tabSegment.addTab(tab2);
        }

        contentViewPager.setAdapter(pagerAdapter);
        contentViewPager.setCurrentItem(mCurrentPageIndex);
        int space = QMUIDisplayHelper.dp2px(_mActivity, 16);
        tabSegment.setIndicator(new QMUITabIndicator(QMUIDisplayHelper.dp2px(_mActivity, 2), false, true));
        tabSegment.setDefaultTextSize(QMUIDisplayHelper.dp2px(_mActivity, 16), QMUIDisplayHelper.dp2px(_mActivity, 16));
        tabSegment.setPadding(space, 0, space, 0);
        tabSegment.setupWithViewPager(contentViewPager, false);
        tabSegment.addOnTabSelectedListener(new QMUITabSegment.OnTabSelectedListener() {

            @Override
            public void onTabSelected(int index) {
                LoganManager.w_tableMode(TAG, "當前頁面【" + mTabTitles.get(index) + "】");
            }

            @Override
            public void onTabUnselected(int index) {
            }

            @Override
            public void onTabReselected(int index) {
            }

            @Override
            public void onDoubleTap(int index) {
            }
        });
    }

    @Override
    public boolean onBackPressedSupport() {
        return super.onBackPressedSupport();
    }

    private OnDiscountItemClickListener onDiscountItemClickListener;

    public void setOnDiscountItemClickListener(OnDiscountItemClickListener onDiscountItemClickListener) {
        this.onDiscountItemClickListener = onDiscountItemClickListener;
    }

    public interface OnDiscountItemClickListener {
        void onBillDiscountClick(Discount item, int position);

        void onCouponClick(MemberCoupon item, int position);
    }
}
