package com.gingersoft.gsa.cloud.common.rxjava;

import com.gingersoft.gsa.cloud.common.loadsir.LoadsirUtil;
import com.kingja.loadsir.core.LoadService;

import io.reactivex.SingleObserver;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandlerFactory;

/**
 * @作者: bin
 * @創建時間: 2021-04-07 14:03
 * @更新時間: 2021-04-07 14:03
 * @描述:
 */
public abstract class ErrorHandleSingleSubscriber<T> implements SingleObserver<T> {

    private ErrorHandlerFactory mHandlerFactory;
    private LoadService mLoadService;

    public ErrorHandleSingleSubscriber(RxErrorHandler rxErrorHandler) {
        this.mHandlerFactory = rxErrorHandler.getHandlerFactory();
    }

    public ErrorHandleSingleSubscriber(RxErrorHandler rxErrorHandler, LoadService loadService) {
        this.mHandlerFactory = rxErrorHandler.getHandlerFactory();
        this.mLoadService = loadService;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {

    }

    @Override
    public void onSuccess(T t) {

    }

    @Override
    public void onError(@NonNull Throwable t) {
        t.printStackTrace();
        //如果你某个地方不想使用全局错误处理,则重写 onError(Throwable) 并将 super.onError(e); 删掉
        //如果你不仅想使用全局错误处理,还想加入自己的逻辑,则重写 onError(Throwable) 并在 super.onError(e); 后面加入自己的逻辑
        mHandlerFactory.handleError(t);
        if (mLoadService != null) {
            //统一处理反馈页error显示信息
            LoadsirUtil.showCallbackByError(t, mLoadService);
        }
    }

}
