package com.gingersoft.gsa.cloud.order.bean.response;

import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * Created by Wyh on 2020/1/17.
 */
@Data
public class OrderResponse {
    /**
     * id : 40553
     * orderNo : gs204650350122922
     * status : 0
     * totalAmount : 141.qq
     * totalPoints : 0.0
     * createTime : Jan 14, 2020 7:49:50 PM
     * orderDetails : [{"id":1621502,"productName":"胡椒排骨涼瓜煲","productId":"4257","price":58,"lunchboxPrice":0,"number":1,"createTime":"Jan 14, 2020 8:00:11 PM","status":0},{"id":1621503,"productName":"海南雞(例牌)","productId":"4258","price":83,"lunchboxPrice":0,"number":1,"createTime":"Jan 14, 2020 8:00:11 PM","status":0}]
     */
    private long id = -1;
    private String orderNo;
    private int status;
    private int person;
    private double totalAmount;
    private double totalPoints;
    /**
     * 生成訂單時間
     */
    private String createTime;

    private MemberInfo memberInfo;
    private List<OrderDiscountResponse> discountDetails;
    private List<OrderDetailsBean> orderDetails;

    /**
     * N5支付ID
     * 有支付異常事項需要處理時才返回
     */
    @Nullable
    private String txnId;
    @Nullable
    private String payName;

    public OrderResponse() {
    }

    public OrderResponse(OrderResponse orderBean) {
        this.id = orderBean.id;
        this.orderNo = orderBean.orderNo;
        this.status = orderBean.status;
        this.person = orderBean.person;
        this.memberInfo = orderBean.memberInfo;
        this.discountDetails = orderBean.discountDetails;
        this.createTime = orderBean.createTime;
    }

    @Data
    public static class OrderDetailsBean implements Serializable {
        /**
         * id : 1621502
         * orderId : 47039
         * parentId : 1639956
         * productName : 胡椒排骨涼瓜煲
         * productId : 4257
         * price : 58.0
         * lunchboxPrice : 0.0
         * number : 1
         * createTime : Jan 14, 2020 8:00:11 PM
         * status : 0
         */
        private Long id;
        private String productName;
        private long productId;
        /**
         * 單價
         */
        private double price;
        private double lunchboxPrice;
        private int number;
        private String createTime;
        private int status;

        private byte type;
        private long parentId;
        private long orderId;
        /**
         * 打印設定, 用逗號分隔, *=切紙
         */
        private String printSetIng;
        /**
         * 廚房單打印主項
         */
        private long ktPrintMainItem;
        /**
         * 是否参与折扣#0:不參與;1:參與;
         */
        private long ablediscount;
        /**
         * 是否参与服務費#0:不參與;1:參與;
         **/
        private byte scAble = 1;
        /**
         * 折扣實體
         */
        private List<RestaurantDiscountVO> discountList;

        /**
         * 額外食品加分
         */
        private double pointsAdd;
        /**
         * 換購食品所需積分
         */
        private double pointsRedeem;

        /**
         * 0=系統顏色, 1=黑色, 2=紅色
         */
        private long printFont;
        /**
         * 當金額=0時, 是否打印在帳單上
         */
        private long printToBill;
        /**
         * 0食品清单打印 账单打印//1食品清单不打印 账单不打印//2食品清单打印 账单不打印//3食品清单不打印 账单打印
         */
        private long printTo;
        /**
         * 是否打印价格
         */
        private long ktShowPrice;
        /**
         * 成本價
         */
        private Double cost;

        /**
         * 自定義字段
         */
        /**
         * 商品父級ID
         */
        private long topId;
        private long memberId;

        @Data
        public static class RestaurantDiscountVO implements Serializable {
            private Long id;
            private long discountId;
            private int type;
            private int discountValue;
            private String remark;
            private double discountAmount;
        }
    }

}
