package com.gingersoft.gsa.cloud.pay;

import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.pay.pos.PosPayAction;
import com.gingersoft.gsa.cloud.pay.pos.bbpos.BBPosManager;
import com.gingersoft.gsa.cloud.pay.pos.hyweb.HywebManager;
import com.gingersoft.gsa.cloud.pay.pos.yedpay.YedpayManager;

/**
 * @作者: bin
 * @創建時間: 2021-04-14 12:28
 * @更新時間: 2021-04-14 12:28
 * @描述:
 */
public class OriginFactory {

    public static PosPayAction createPayOrigin(RequestParms requestParms) {
        if (AppDevices.isHywebPos()) {
            return HywebManager.newInstance();
        } else if (AppDevices.isBBPos()) {
            return BBPosManager.newInstance();
        } else if (AppDevices.isYedpay()) {
            return YedpayManager.newInstance(requestParms);
        }
        return YedpayManager.newInstance(requestParms);
    }

}
