package com.gingersoft.gsa.cloud.pay;

import com.gingersoft.gsa.cloud.pay.pos.PosPayAction;
import com.jess.arms.utils.Preconditions;
import lombok.Getter;

/**
 * @作者: bin
 * @創建時間: 2021-04-15 16:38
 * @更新時間: 2021-04-15 16:38
 * @描述:
 */
@Getter
public class PaymentControl {

    private static PaymentControl sPaymentControl;

    public static PaymentControl newInstance() {
        if (sPaymentControl == null) {
            sPaymentControl = new PaymentControl();
        }
        return sPaymentControl;
    }

    private PaymentControl() {
    }

    public void pay(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.pay(requestParms);
    }

    public void tip(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.tip(requestParms);
    }

    public void refund(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.refund(requestParms);
    }

    public void voidO(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.void0(this);
    }

    public void retrieval(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.retrieval(this);
    }

    public void printStub(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.printStub(this);
    }

    public void settlement(RequestParms requestParms) {
        final PosPayAction payOrigin = OriginFactory.createPayOrigin(requestParms);
        Preconditions.checkNotNull(payOrigin);
        payOrigin.settlement(this);
    }

}
