package com.gingersoft.gsa.cloud.pay.lifecycle.fragment;

import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.order.R;
import com.gingersoft.gsa.cloud.order.R2;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.PayStep;
import com.gingersoft.gsa.cloud.pay.lifecycle.di.component.DaggerPayFlowComponent;
import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.view.customstatus.CustomStatusView;
import com.gingersoft.gsa.cloud.pay.widget.StatusLoadingDialog;
import com.jess.arms.base.BaseDialogFragment;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.pay.lifecycle.contract.PayFlowContract;
import com.gingersoft.gsa.cloud.pay.lifecycle.presenter.PayFlowPresenter;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import butterknife.BindView;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/15/2021 14:44
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class PayFlowFragment extends BaseDialogFragment<PayFlowPresenter> implements PayFlowContract.View {

    @BindView(R2.id.ll_container)
    LinearLayout ll_container;
    @BindView(R2.id.as_status)
    CustomStatusView as_status;
    @BindView(R2.id.tv_status)
    TextView tv_status;

    private RequestParms requestParms;
    private PayAction action;

    private final long mCancelDelayMillis = 2000;
    private String mLoadingText = "支付中...";

    public static PayFlowFragment newInstance(RequestParms parms) {
        PayFlowFragment fragment = new PayFlowFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("requestParms", parms);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerPayFlowComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        getDialog().setCancelable(false);
        return inflater.inflate(R.layout.dialog_pay_loading, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        mWindow.setBackgroundDrawable(new ColorDrawable(ArmsUtils.getColor(mContext, R.color.trans)));
//        WindowManager.LayoutParams lp = mWindow.getAttributes();
//        lp.width = QMUIDisplayHelper.dp2px(mContext,100);
//        lp.height = QMUIDisplayHelper.dp2px(mContext,200);
//        lp.gravity = Gravity.CENTER;
//        lp.windowAnimations = android.R.style.Animation_InputMethod;
//        mWindow.setAttributes(lp);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        requestParms = (RequestParms) arguments.getSerializable("requestParms");
        action = requestParms.getAction();

        tv_status.setText(mLoadingText);
        ll_container.setLayoutParams(new FrameLayout.LayoutParams((int) (ArmsUtils.getScreenWidth(mContext) * 0.4), (int) (ArmsUtils.getScreenWidth(mContext) * 0.4)));

        showStatusLoadingDialog(PayStep.LOADING);

        mPresenter.excutePayFlow(requestParms);
    }

    @Override
    public void showStatusLoadingDialog(PayStep status) {
        String loadingText = action.getLoadingStepText(status);
        setStatusText(loadingText);
        switch (status) {
            case LOADING:
                loadLoading();
                break;
            case SUCCESS:
                loadSuccess();
                break;
            case FAILURE:
                loadFailure();
                break;
        }
    }

    public void setStatusText(String text) {
        tv_status.setText(text);
    }

    public void loadLoading() {
        as_status.loadLoading();
    }

    public void loadSuccess() {
        as_status.loadSuccess();
    }

    public void loadFailure() {
        as_status.loadFailure();
    }

    public void clearLoadingAnim() {
        if (as_status != null && as_status.getAnimation() != null) {
            as_status.clearAnimation();
        }
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
    }

    @Override
    public void hideLoading() {
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        clearLoadingAnim();
        as_status.postDelayed(new Runnable() {
            @Override
            public void run() {
                getDialog().cancel();
            }
        }, mCancelDelayMillis);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        LoganManager.w_code(TAG, "onActivityResult-》" + "resultCode=" + resultCode + "  requestCode=" + requestCode);
        if (resultCode == android.app.Activity.RESULT_OK) {
            switch (requestCode) {
                case 555: {
                    if (intent.getExtras() != null) {
                        String status = (String) intent.getExtras().get("status");
                        String transaction_id = (String) intent.getExtras().get("transaction_id");
                        LoganManager.w_code(TAG, "onActivityResult-》" + "status=" + status + "  transaction_id=" + transaction_id);
                        mPresenter.yedPayUpdateStatus(transaction_id, requestParms.getOrderId(), requestParms.getPayType(), requestParms.getResturantId());
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void startActivityForResult(Intent intent) {
        startActivityForResult(intent, 555);
    }
}
