package com.gingersoft.gsa.cloud.pay.lifecycle.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.pay.lifecycle.model.service.PayFlowService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.pay.lifecycle.contract.PayFlowContract;

import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/15/2021 14:44
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class PayFlowModel extends BaseModel implements PayFlowContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public PayFlowModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public Single<BaseResult> yedPayFindSaleStatus(RequestBody body) {
        return mRepositoryManager.obtainRetrofitService(PayFlowService.class)
                .yedPayFindSaleStatus(body);
    }

    @Override
    public Single<BaseResult> yedPayRefundOrder(RequestBody body) {
        return mRepositoryManager.obtainRetrofitService(PayFlowService.class)
                .yedPayRefundOrder(body);
    }
}