package com.gingersoft.gsa.cloud.pay.lifecycle.model.service;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;

import io.reactivex.Single;
import io.reactivex.Single;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/1/17.
 */
public interface PayFlowService {

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("posPay/getTxnId" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getTxnId(@Query("type") int type, @Query("parm") String parm, @Query("gsposShopId") String shopName, @Query("tableId") int tableId, @Query("tableNumber") String tableNumber);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("posPay/getRefundTxnId" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getRefundTxnId(@Query("tableId") int tableId, @Query("tableNumber") String tableNumber, @Query("memberId") long memberId);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("posPay/getCancelTxnId" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getCancelTxnId(@Query("tableId") int tableId, @Query("tableNumber") String tableNumber, @Query("memberId") long memberId);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("orderPay/updatePosRefund" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> updatePosRefund(@Query("tableId") int tableId, @Query("memberId") Long memberId, @Query("couponMemberId") long couponMemberId, @Query("couponNo") String couponNo, @Query("restaurantId") int restaurantId);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("member/getMemberWalletList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getMemberWalletList(@Query("brandId") int brandId, @Query("memberId") long memberId, @Query("limitType") long limitType, @Query("pageIndex") long pageIndex, @Query("pageSize") long pageSize);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("orderPay/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> add(@Query("tableId") int tableId, @Query("tableNumber") String tableNumber, @Query("memberId") long memberId);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("posPay/updatePosCancel" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> updatePosCancel(@Query("tableId") int tableId, @Query("tableNumber") String tableNumber, @Query("memberId") long memberId);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("gsaYedPay/updatePayStatus" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> yedPayFindSaleStatus(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_pay"})
    @POST("gsaYedPay/refund" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> yedPayRefundOrder(@Body RequestBody requestBody);
}
