package com.gingersoft.gsa.cloud.pay.pos.bean;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2020-12-25 17:54
 * @更新時間: 2020-12-25 17:54
 * @描述: 支付日誌實體
 */
@Data
public class PosPayLog {

    private Long id;
    /**
     * 訂單ID
     */
    private Long orderId;
    /**
     * 設備ID
     */
    private String deviceId;
    /**
     * 業務類型：1 支付，2 取消，3 退款，4 追加小費，5 清機
     */
    private Byte businessType;
    /**
     * 狀態：0 未處理，1 成功，2 失敗
     */
    private Byte status;
    /**
     * N5 回調內容
     */
    private Long content;
    /**
     * 創建時間
     */
    private Long createTime;
    /**
     * 創建人ID
     */
    private Long createBy;
    /**
     * 更新時間
     */
    private Long updateTime;
    /**
     * 更新人ID
     */
    private Long updateBy;

    /**
     * 業務類型：1 支付，2 取消，3 退款，4 追加小費，5 清機
     */
    public static final byte BUSINESS_TYPE_PAY = 1;
    public static final byte BUSINESS_TYPE_CANCEL = 2;
    public static final byte BUSINESS_TYPE_REFUND = 3;
    public static final byte BUSINESS_TYPE_TIP = 4;
    public static final byte BUSINESS_TYPE_SETTLE = 5;

    /**
     * 狀態：0 未處理，1 成功，2 失敗
     */
    public static final byte STATUS_UNTREATED = 0;
    public static final byte STATUS_SUCCESS = 1;
    public static final byte STATUS_FAILURE = 2;
}
