package com.gingersoft.gsa.cloud.pay.pos.yedpay;

import android.util.SparseArray;

import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.pos.PosPayAction;
import com.gingersoft.gsa.cloud.pay.pos.yedpay.constant.YedpayConstant;

/**
 * @作者: bin
 * @創建時間: 2021-04-14 12:08
 * @更新時間: 2021-04-14 12:08
 * @描述:
 */
public class YedpayManager implements PosPayAction<RequestParms> {

    private static YedpayManager sYedpayManager;
    private final SparseArray<String> mYedpayTypeMap = new SparseArray<>();
    private RequestParms mRequestParms;
    private YedpayCallback mYedpayCallback;


    public static YedpayManager newInstance(RequestParms requestParms) {
        if (sYedpayManager == null) {
            sYedpayManager = new YedpayManager(requestParms);
        }
        return sYedpayManager;
    }

    private YedpayManager(RequestParms requestParms) {
        this.mRequestParms = requestParms;
        this.mYedpayCallback = (YedpayCallback) requestParms.getCallback();
        initPayTypeMap();
    }

    private void initPayTypeMap() {
        mYedpayTypeMap.put(1106, YedpayConstant.Method.ALIPAy);
        mYedpayTypeMap.put(1107, YedpayConstant.Method.wechatpay);
    }

    private String getPayType(int type) {
        if (mYedpayTypeMap.indexOfKey(type) != -1) {
            return mYedpayTypeMap.get(type);
        }
        return null;
    }

    @Override
    public void void0(RequestParms params) {

    }

    @Override
    public void tip(RequestParms params) {

    }

    @Override
    public void retrieval(RequestParms params) {

    }

    @Override
    public void printStub(RequestParms params) {

    }

    @Override
    public void settlement(RequestParms params) {

    }

    @Override
    public void pay(RequestParms params) {
        String uriString = "yedpayapp://transaction?g=" + getPayType(params.getPayType()) + "&a=" + params.getPayMoney() + "";
        mYedpayCallback.callSaleUri(uriString);
    }

    @Override
    public void refund(RequestParms params) {
        mYedpayCallback.refundResult(true);
    }


}
