package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.BuyIngredientsModule;
import com.gingersoft.supply_chain.mvp.contract.BuyIngredientsContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.BuyIngredientsFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/10/2021 14:55
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = BuyIngredientsModule.class, dependencies = AppComponent.class)
public interface BuyIngredientsComponent {
    void inject(BuyIngredientsFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        BuyIngredientsComponent.Builder view(BuyIngredientsContract.View view);

        BuyIngredientsComponent.Builder appComponent(AppComponent appComponent);

        BuyIngredientsComponent build();
    }
}