/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.simpleserial;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.simpleserial.ReceiveListener;
import com.epson.epos2.simpleserial.SerialStatusInfo;
import java.lang.reflect.Method;

public class SimpleSerial {
    private long mSerialHandle = 0L;
    private Context mContext = null;
    private ReceiveListener mReceiveListener = null;
    private ConnectionListener mConnectionListener = null;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_DEFAULT = -2;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    private static int connection;

    private native int nativeEpos2CreateHandle(long[] var1);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native int nativeEpos2SendCommand(long var1, byte[] var3);

    protected native SerialStatusInfo nativeEpos2GetStatus(long var1);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public SimpleSerial(Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("SimpleSerial", context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("SimpleSerial", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeSerialInstance();
        this.outputLogReturnFunction("SimpleSerial", 0, context);
    }

    protected void initializeSerialInstance() throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mSerialHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mSerialHandle != 0L) {
                this.nativeEpos2Disconnect(this.mSerialHandle);
                this.nativeEpos2DestroyHandle(this.mSerialHandle);
                this.mSerialHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mSerialHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mSerialHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mSerialHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public void sendCommand(byte[] data) throws Epos2Exception {
        this.outputLogCallFunction("sendCommand", new Object[]{data});
        try {
            this.checkHandle();
            if (null == data) {
                throw new Epos2Exception(1);
            }
            int result = this.nativeEpos2SendCommand(this.mSerialHandle, data);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendCommand", ex);
            this.outputLogReturnFunction("sendCommand", ex.getErrorStatus(), new Object[]{data});
            throw ex;
        }
        this.outputLogReturnFunction("sendCommand", 0, new Object[]{data});
    }

    public void setReceiveEventListener(ReceiveListener target) {
        this.outputLogCallFunction("setReceiveEventListener", target);
        if (this.mSerialHandle != 0L) {
            this.mReceiveListener = target != null ? target : null;
        }
    }

    protected void onSimpleSerialReceive(byte[] data) {
        this.outputLogCallFunction("onSimpleSerialReceive", data, this);
        if (null != this.mReceiveListener) {
            this.mReceiveListener.onSimpleSerialReceive(this, data);
            this.outputLogEvent("onSimpleSerialReceive", "data->", data);
        }
        this.outputLogReturnFunction("onSimpleSerialReceive", 0, data, this);
    }

    public SerialStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        SerialStatusInfo status = this.nativeEpos2GetStatus(this.mSerialHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mSerialHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mSerialHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mSerialHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mSerialHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mSerialHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mSerialHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mSerialHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mSerialHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mSerialHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

