/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.simpleserial;

import com.epson.eposdevice.EposException;
import com.epson.eposdevice.simpleserial.CommandReplayListener;
import com.epson.eposdevice.simpleserial.NativeSimpleSerial;

public abstract class SimpleSerial
extends NativeSimpleSerial {
    private CommandReplayListener mCommandReplayListener = null;
    private long mSscHandle = 0L;

    private void OnSimpleSerialCommandReply(String ipAddress, String deviceId, byte[] data) {
        if (null != this.mCommandReplayListener) {
            this.outputLogEvent("onSimpleSerialCommandReplay", ipAddress, deviceId, data);
            this.mCommandReplayListener.onSimpleSerialCommandReplay(ipAddress, deviceId, data);
        }
    }

    protected SimpleSerial(long ssHandle) {
        this.mSscHandle = ssHandle;
    }

    protected long getInnerHandle() {
        return this.mSscHandle;
    }

    protected void innerDeleteInstance() {
        this.nativeSetSscCommandReplyEventCallback(this.mSscHandle, null);
        this.mSscHandle = 0L;
    }

    protected void checkHandle() throws EposException {
        if (this.mSscHandle == 0L) {
            throw new EposException(255);
        }
    }

    public void sendCommand(byte[] data) throws EposException {
        this.outputLogCallFunction("sendCommand", new Object[]{data});
        try {
            this.checkHandle();
            if (null == data) {
                throw new EposException(1);
            }
            int result = this.nativeSscSendCommand(this.mSscHandle, data);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("sendCommand", ex);
            throw ex;
        }
        this.outputLogReturnFunction("sendCommand", new Object[]{data});
    }

    public void setCommandReplyEventCallback(CommandReplayListener target) {
        if (this.mSscHandle != 0L) {
            if (target != null) {
                this.mCommandReplayListener = target;
                this.nativeSetSscCommandReplyEventCallback(this.mSscHandle, this);
            } else {
                this.nativeSetSscCommandReplyEventCallback(this.mSscHandle, null);
                this.mCommandReplayListener = null;
            }
        }
    }

    @Override
    protected void nativeOnSimpleSerialCommandReply(String ipAddress, String deviceId, byte[] data) {
        this.OnSimpleSerialCommandReply(ipAddress, deviceId, data);
    }

    protected abstract void outputLogCallFunction(String var1, Object ... var2);

    protected abstract void outputLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputException(String var1, Exception var2);

    protected abstract void outputLogEvent(String var1, Object ... var2);
}

