package com.gingersoft.coldchain_module.mvp.contract;

import com.gingersoft.coldchain_module.mvp.model.bean.OrderList;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


public interface OrderListContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadOrderList(List<OrderList.DataBeanX.DataBean> data);

        void notifyByPosition(int position, OrderList.DataBeanX.DataBean dataBean);

        void removeItem(int position);

        void loadOrderTotalNum(OrderList.DataBeanX.DataBean bean);

//        void getOrderDetails(OrderDetails.DataBean dataBean);

    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<OrderList> getOrderList(RequestBody requestBody);

        Observable<OrderDetails> findOrderDetails(RequestBody requestBody);

        Observable<ShipAnyOrdersNewBean> thirdDelivery(RequestBody requestBody);

        Observable<UpdateOrderStatusBean> updateOrderStatus(RequestBody requestBody);

        Observable<BaseResult> addPrj(RequestBody requestBody);
    }
}
