package com.gingersoft.coldchain_module.mvp.contract;

import com.gingersoft.coldchain_module.mvp.model.bean.SupplementInfoBean;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementResultBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import io.reactivex.Observable;
import okhttp3.RequestBody;


public interface SupplementOrderContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadNumber(SupplementInfoBean bean);

        void submissionComplete();

        void submissionFail();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<SupplementInfoBean> getNumByOrderType(RequestBody requestBody);

        Observable<SupplementResultBean> submitOrder(RequestBody requestBody);
    }
}
