package com.gingersoft.gsa.delivery_pick_mode.mvp.server;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.delivery_pick_mode.mvp.bean.RiceponAddOrderBean;
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.UpdateOrderStatusBean;
import com.gingersoft.gsa.delivery_pick_mode.mvp.model.MemberAddressInfoBean;

import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface SendOrderServer {

    @Headers({"Domain-Name: member-web"})
    @GET("member/getAddressAndResSetting?" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<String> getConfirmTakeawayOrderData(@QueryMap Map<String, Object> map);

    @Headers({"Domain-Name: update_version"})
    @POST("order/addOrder2" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<RiceponAddOrderBean> submitOrder(@Body RequestBody requestBody);

    @Headers({"Domain-Name: ricepon_member"})
    @GET("member/getMemberAddressInfo" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MemberAddressInfoBean> getMemberAddressInfo(@Query("phone") String phone);

    @Headers({"Domain-Name: member-web"})
    @POST("order/updateOrderStatus" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<UpdateOrderStatusBean> gsUpdateOrderStatus(@Body RequestBody requestBody);

    @POST("printerRecording/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addPrj(@Body RequestBody requestBody);
}
