package com.gingersoft.gsa.cloud.main.mvp.contract;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessDetailsBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DailyReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DaySalesReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DiscountDetailsReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainBusinessBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.OrderAnalysisBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.OrderDetailsReport;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface BusinessReportContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadChart(List<MainBusinessBean.DataBean> data);

        void loadBillReport(DaySalesReportBean.DataBean dataBean);

        void loadDaySalesReport(List<BusinessBean> businessBeans);

        void loadOrderAnalysis(List<DailyReportBean> dailyReportBeans);

        void loadOrderDetailsReport(List<DailyReportBean> dailyReportBeans);

        void loadDiscountDetailsReport(List<DailyReportBean> dailyReportBeans);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<MainBusinessBean> getRestaurantBusinessAmount(Map<String, String> map);

//        Observable<BusinessDetailsBean> getRestaurantBusinessDetails(Map<String, String> map);

        Observable<DaySalesReportBean> getDaySalesReport(Map<String, String> map);

        Observable<OrderAnalysisBean> getOrderAnalysis(Map<String, String> map);

        Observable<OrderDetailsReport> getOrderDetailsReport(Map<String, String> map);

        Observable<DiscountDetailsReportBean> getDiscountDetails(Map<String, String> map);

    }
}
