package com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.FoodMenuAdapter;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.mvp.IPresenter;

import me.yokeyword.fragmentation.ISupportFragment;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/3
 * Time: 14:22
 * Use:
 */
public abstract class BaseFoodMenuFragment<P extends IPresenter> extends BaseFragment<P> {

    public final static String FRAGMENT_TYPE = "fragmentType";
    public final static String TITLE_KEY = "title";
    public final static String TO_SHELL_ACTIVITY = "toShellActivity";
    /**
     * 新增食品組
     */
    public final static int NEW_FOOD_GROUP = 1;
    /**
     * 食品詳情的基本屬性頁面
     */
    public final static int FOOD_PROPERTIES = 2;
    /**
     * 選擇時段
     */
    public final static int SELECT_TIME_PERIOD = 3;
    /**
     * 新增時段
     */
    public final static int NEW_TIME_PERIOD = 4;
    /**
     * 選擇食品組
     */
    public final static int SELECT_FOOD_GROUP = 5;
    /**
     * 選擇餐種
     */
    public final static int SELECT_FOOD_TYPE = 6;

    /**
     * 新增餐種
     */
    public final static int NEW_FOOD_TYPE = 7;

    /**
     * 加配細項
     */
    public final static int ADD_FOOD_ITEM = 8;

    /**
     * 選擇細項組
     */
    public final static int SELECT_FOOD_ITEM_GROUP = 9;

    /**
     * 新增細項組
     */
    public final static int ADD_FOOD_ITEM_GROUP = 10;

    /**
     * 新增細項
     */
    public final static int NEW_FOOD_ITEM = 11;

    public final static int SELECT_PRINT = 13;
    /**
     * 食品管理
     */
    public final static int FOOD_MANGER = 14;
    /**
     * 細項管理
     */
    public final static int FOOD_ITEM_MANGER = 15;
    /**
     * 套餐管理
     */
    public final static int FOOD_SET_MEAL_MANGER = 16;
    /**
     * 食品的細項頁面
     */
    public final static int FOOD_ITEMS_PAGE = 17;
    /**
     * 食品的套餐頁面
     */
    public final static int FOOD_SET_MEAL_PAGE = 18;
    /**
     * 加配套餐
     */
    public final static int ADD_FOOD_SET_MEAL = 19;
    /**
     * 新增套餐組
     */
    public final static int NEW_FOOD_SET_MEAL_GROUP = 20;
    /**
     * 新增套餐
     */
    public final static int NEW_FOOD_SET_MEAL = 21;
    /**
     * 選擇套餐組
     */
    public final static int SELECT_FOOD_SET_MEAL_GROUP = 22;
    /**
     * 選擇食品
     */
    public final static int SELECT_FOOD = 23;

    /**
     * 選擇列表
     */
    public final static int SELECT_LIST = 24;
    /**
     * 排除內容
     */
    public final static int SELECT_EXCLUDE_LIST = 25;

    protected void toFragmentByAdapter(FoodMenuAdapter adapter, int position) {
        if (adapter.getItemViewType(position) == FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT) {
            toFragmentByFragmentType(adapter.getData().get(position).getFragmentType());
        }
    }

    public static ISupportFragment getFragmentByType(int fragmentType) {
        ISupportFragment fragment = null;
        switch (fragmentType) {
            case NEW_FOOD_GROUP:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增食品組", false);
                break;
            case FOOD_PROPERTIES:
                fragment = NewFoodFragment.newInstance();
                break;
            case SELECT_TIME_PERIOD:
                fragment = EditFoodFragment.newInstance(fragmentType, "選擇時段");
                break;
            case SELECT_FOOD_GROUP:
                fragment = EditFoodFragment.newInstance(fragmentType, "選擇食品組");
                break;
            case SELECT_FOOD_TYPE:
                fragment = EditFoodFragment.newInstance(fragmentType, "選擇餐種");
                break;
            case NEW_TIME_PERIOD:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增時段");
                break;
            case NEW_FOOD_TYPE:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增餐種");
                break;
            case ADD_FOOD_ITEM:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "加配細項");
                break;
            case SELECT_FOOD_ITEM_GROUP:
                fragment = EditFoodFragment.newInstance(fragmentType, "選擇細項組");
                break;
            case ADD_FOOD_ITEM_GROUP:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增細項組");
                break;
            case NEW_FOOD_ITEM:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增細項");
                break;
            case FOOD_MANGER:
            case FOOD_ITEM_MANGER:
            case FOOD_SET_MEAL_MANGER:
                fragment = FoodMenuFragment.newInstance(fragmentType);
                break;
            case ADD_FOOD_SET_MEAL:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "加配套餐");
                break;
            case NEW_FOOD_SET_MEAL:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增套餐項");
                break;
            case NEW_FOOD_SET_MEAL_GROUP:
                fragment = NewlyAddedFragment.newInstance(fragmentType, "新增套餐組");
                break;
            case SELECT_FOOD_SET_MEAL_GROUP:
                fragment = EditFoodFragment.newInstance(fragmentType, "選擇套餐組");
                break;
            case SELECT_LIST:
                fragment = SelectFragment.newInstance(fragmentType, "默認選擇");
                break;
            case SELECT_EXCLUDE_LIST:
                fragment = SelectFragment.newInstance(fragmentType, "排除內容");
                break;
            default:

                break;
        }
        return fragment;
    }

    protected void toFragmentByFragmentType(int fragmentType) {
        ISupportFragment fragment = getFragmentByType(fragmentType);
        if (fragment != null) {
            startForResult(fragment, fragmentType);
        }
    }
}
