package com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerEditFoodItemsComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.EditFoodItemsContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.EditFoodItemsPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu.ShellActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * 食品的細項、套餐
 */
public class EditFoodItemsFragment extends BaseFoodMenuFragment<EditFoodItemsPresenter> implements EditFoodItemsContract.View, View.OnClickListener {

    @BindView(R2.id.tv_add_item)
    QMUIAlphaTextView tvAddItem;
    @BindView(R2.id.tv_food_item_manger)
    QMUIAlphaTextView tvFoodItemManger;
    @BindView(R2.id.rv_food_items)
    RecyclerView rvFoodItems;
    @BindView(R2.id.tv_food_item_name_text)
    TextView tvListTitleName;

    private int fragmentType;

    public static EditFoodItemsFragment newInstance(int fragmentType) {
        EditFoodItemsFragment fragment = new EditFoodItemsFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(FRAGMENT_TYPE, fragmentType);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerEditFoodItemsComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_edit_food_items, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            fragmentType = arguments.getInt(FRAGMENT_TYPE);
        }
        if (fragmentType == FOOD_ITEMS_PAGE) {
            tvAddItem.setText("加配細項+");
            tvFoodItemManger.setText("細項管理");
            tvListTitleName.setText("細項組名稱");
        } else if (fragmentType == FOOD_SET_MEAL_PAGE) {
            tvAddItem.setText("加配套餐+");
            tvFoodItemManger.setText("套餐管理");
            tvListTitleName.setText("套餐名稱");
        }
    }

    /**
     * 通过此方法可以使 Fragment 能够与外界做一些交互和通信, 比如说外部的 Activity 想让自己持有的某个 Fragment 对象执行一些方法,
     * 建议在有多个需要与外界交互的方法时, 统一传 {@link Message}, 通过 what 字段来区分不同的方法, 在 {@link #setData(Object)}
     * 方法中就可以 {@code switch} 做不同的操作, 这样就可以用统一的入口方法做多个不同的操作, 可以起到分发的作用
     * <p>
     * 调用此方法时请注意调用时 Fragment 的生命周期, 如果调用 {@link #setData(Object)} 方法时 {@link Fragment#onCreate(Bundle)} 还没执行
     * 但在 {@link #setData(Object)} 里却调用了 Presenter 的方法, 是会报空的, 因为 Dagger 注入是在 {@link Fragment#onCreate(Bundle)} 方法中执行的
     * 然后才创建的 Presenter, 如果要做一些初始化操作,可以不必让外部调用 {@link #setData(Object)}, 在 {@link #initData(Bundle)} 中初始化就可以了
     * <p>
     * Example usage:
     * <pre>
     * public void setData(@Nullable Object data) {
     *     if (data != null && data instanceof Message) {
     *         switch (((Message) data).what) {
     *             case 0:
     *                 loadData(((Message) data).arg1);
     *                 break;
     *             case 1:
     *                 refreshUI();
     *                 break;
     *             default:
     *                 //do something
     *                 break;
     *         }
     *     }
     * }
     *
     * // call setData(Object):
     * Message data = new Message();
     * data.what = 0;
     * data.arg1 = 1;
     * fragment.setData(data);
     * </pre>
     *
     * @param data 当不需要参数时 {@code data} 可以为 {@code null}
     */
    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @OnClick({R2.id.tv_add_item, R2.id.tv_food_item_manger})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.tv_add_item) {
            //加配
            Intent intent = new Intent(mContext, ShellActivity.class);
            if (fragmentType == FOOD_ITEMS_PAGE) {
                intent.putExtra(FRAGMENT_TYPE, ADD_FOOD_ITEM);
            } else if (fragmentType == FOOD_SET_MEAL_PAGE) {
                intent.putExtra(FRAGMENT_TYPE, ADD_FOOD_SET_MEAL);
            }
            startActivity(intent);
        } else if (viewId == R.id.tv_food_item_manger) {
            //管理
            Intent intent = new Intent(mContext, ShellActivity.class);
            if (fragmentType == FOOD_ITEMS_PAGE) {
                intent.putExtra(FRAGMENT_TYPE, FOOD_ITEM_MANGER);
            } else if (fragmentType == FOOD_SET_MEAL_PAGE) {
                intent.putExtra(FRAGMENT_TYPE, FOOD_SET_MEAL_MANGER);
            }
            startActivity(intent);
        }

    }
}
