package com.joe.print.di.module;

import com.jess.arms.di.scope.FragmentScope;

import dagger.Module;
import dagger.Provides;

import com.joe.print.mvp.contract.LocalPrintContract;
import com.joe.print.mvp.model.LocalPrintModel;


@Module
public class LocalPrintModule {
    private LocalPrintContract.View view;

    /**
     * 构建LocalPrintModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public LocalPrintModule(LocalPrintContract.View view) {
        this.view = view;
    }

    @FragmentScope
    @Provides
    LocalPrintContract.View provideLocalPrintView() {
        return this.view;
    }

    @FragmentScope
    @Provides
    LocalPrintContract.Model provideLocalPrintModel(LocalPrintModel model) {
        return model;
    }
}