package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.restaurant.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.TakeawayOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintTakeawayCheckoutContent;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.joe.print.R;
import com.joe.print.mvp.ui.adapter.BillItemAdapter;
import com.joe.print.mvp.ui.adapter.OtherOrderAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 打印外賣接單   結賬單
 */
public class PrintOtherOrderClosing extends PrinterRoot<PrintTakeawayCheckoutContent> {


    private PrintTakeawayCheckoutContent mTakeawayCheckoutContent;

    @Override
    protected void setPrintContent(PrintTakeawayCheckoutContent printContent) {
        this.mTakeawayCheckoutContent = printContent;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        OrderDetails.DataBean dataBean = TakeawayOrder.getInstance().getShoppingCart().getDeliveryAndPickupData();
        if (dataBean != null) {
            Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
            List<Bitmap> bitmaps = new ArrayList<>();
            bitmaps.add(getBitmap(mContext, dataBean, deviceBean));
            bitmapMaps.put("", bitmaps);
            return bitmapMaps;
        }
        return null;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {

        if (mTakeawayCheckoutContent == null) {
            return new String[]{"<html><body></body></html>"};
        }
        String stringBuilder = "<html><body>" +
                getTakewayPrintContent(mTakeawayCheckoutContent, deviceBean) +
                "</body></html>";
        int printCount = getPrintCount(mContext);
        String[] pritContent = new String[printCount];
        for (int i = 0; i < printCount; i++) {
            pritContent[i] = stringBuilder;
        }
        return pritContent;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.DeliveryClosingPC, 1);
    }

    private Bitmap getBitmap(Context mContext, OrderDetails.DataBean data, PrinterDeviceBean deviceBean) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        //頭部
        layout.addView(getHeader(mContext));
        //訂單信息
        layout.addView(getTakeawayOrderInfo(mContext, data));
        //食品
        layout.addView(getTextLine(mContext, "項目"));
        layout.addView(getDiningFoodList(mContext, orderDetailCastPrintFoodItem(OrderDetail.productMameBeanToOrderDetail(1, data.getPRODUCT_NAME())), deviceBean, 1, true));
        layout.addView(getLine(mContext));
        //訂單金額信息
        List<PrintBillItem> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", MONETARY_UNIT + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", MONETARY_UNIT + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", MONETARY_UNIT + data.getDELIVERY_CHARGE()));
        }
        double totalAmount = Double.parseDouble(data.getTOTAL_AMOUNT());
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-" + MONETARY_UNIT + coupon.getDiscount_amount()));
                totalAmount = MoneyUtil.sub(totalAmount, coupon.getDiscount_amount());
            }
        }
        layout.addView(getTakeawayBillInfoView(mContext, billData));
        layout.addView(getLine(mContext));
        //總金額34sp
        layout.addView(getTakeawayLargeAmount(mContext, "總金額：", MONETARY_UNIT + data.getTOTAL_AMOUNT()));
        layout.addView(getLine(mContext));
        addTakeawayPayViews(mContext, layout, data.getPayMultiple(), totalAmount);

        //會員信息
        layout.addView(getTakeawayMemberIntegerView(mContext, data));
        layout.addView(getLine(mContext));

        getTakeawayReceiver(mContext, data, layout);

        return viewToZoomBitmap(mContext, layout, deviceBean);
    }

    private PrintBillItem getBillBean(String title, String value) {
        return new PrintBillItem(title, value);
    }

}