package com.gingersoft.supply_chain.mvp.bean;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/4/30
 * Time: 19:46
 * Use:入庫訂單詳情
 */
public class WarehousingOrderDetailsBean {
    /**
     * id : 1106
     * warehousingOrderNo : RK20210430945580
     * name : 山楂糕
     * foodNo : FD1598602755
     * supplierName : 深圳市牛呆呆公司
     * basicUnitName : 個
     * foodQuantity : 0
     * foodPrice : 0
     * totalPrice : 0
     * remarks :
     * foodMarkSn : 0
     */

    private int id;
    private String warehousingOrderNo;
    private String name;
    private String foodNo;
    private String supplierName;
    private String basicUnitName;
    private int foodQuantity;
    private double foodPrice;
    private int totalPrice;
    private String remarks;
    private int foodMarkSn;

    public static List<PurchaseFoodBean> conversionToPurchaseFoodBean(List<WarehousingOrderDetailsBean> warehousingOrderDetailsBean) {
        List<PurchaseFoodBean> purchaseFoodBeans = new ArrayList<>();
        if (warehousingOrderDetailsBean != null) {
            for (WarehousingOrderDetailsBean orderDetailsBean : warehousingOrderDetailsBean) {
                purchaseFoodBeans.add(conversionToPurchaseFoodBean(orderDetailsBean));
            }
        }
        return purchaseFoodBeans;
    }

    public static PurchaseFoodBean conversionToPurchaseFoodBean(WarehousingOrderDetailsBean warehousingOrderDetailsBean) {
        PurchaseFoodBean purchaseFoodBean = new PurchaseFoodBean();
        purchaseFoodBean.setId(warehousingOrderDetailsBean.getId());
        purchaseFoodBean.setName(warehousingOrderDetailsBean.getName());
        purchaseFoodBean.setFoodNo(warehousingOrderDetailsBean.getFoodNo());
        purchaseFoodBean.setSupplierName(warehousingOrderDetailsBean.getSupplierName());
        purchaseFoodBean.setBasicUnitName(warehousingOrderDetailsBean.getBasicUnitName());
        purchaseFoodBean.setFoodQuantity(warehousingOrderDetailsBean.getFoodQuantity());
        purchaseFoodBean.setUnitPrice(warehousingOrderDetailsBean.getFoodPrice());
        purchaseFoodBean.setRemarks(warehousingOrderDetailsBean.getRemarks());
        purchaseFoodBean.setFoodMarkSn(warehousingOrderDetailsBean.getFoodMarkSn());
        purchaseFoodBean.setWarehousingOrderNo(warehousingOrderDetailsBean.getWarehousingOrderNo());
        return purchaseFoodBean;
    }


    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getWarehousingOrderNo() {
        return warehousingOrderNo;
    }

    public void setWarehousingOrderNo(String warehousingOrderNo) {
        this.warehousingOrderNo = warehousingOrderNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFoodNo() {
        return foodNo;
    }

    public void setFoodNo(String foodNo) {
        this.foodNo = foodNo;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getBasicUnitName() {
        return basicUnitName;
    }

    public void setBasicUnitName(String basicUnitName) {
        this.basicUnitName = basicUnitName;
    }

    public int getFoodQuantity() {
        return foodQuantity;
    }

    public void setFoodQuantity(int foodQuantity) {
        this.foodQuantity = foodQuantity;
    }

    public double getFoodPrice() {
        return foodPrice;
    }

    public void setFoodPrice(int foodPrice) {
        this.foodPrice = foodPrice;
    }

    public int getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(int totalPrice) {
        this.totalPrice = totalPrice;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public int getFoodMarkSn() {
        return foodMarkSn;
    }

    public void setFoodMarkSn(int foodMarkSn) {
        this.foodMarkSn = foodMarkSn;
    }
}
