package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.WarehouseOrderBean;
import com.gingersoft.supply_chain.mvp.ui.adapter.WarehousingOrderListAdapter;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/28/2021 19:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface WarehousingOrderListContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadList(WarehousingOrderListAdapter adapter);

        void setDefaultPageState(WarehousingOrderListAdapter adapter);

        /**
         * 關閉加載動畫
         *
         * @param isNoMore 是否還有更多 true 沒有更多了
         */
        void finishLoad(boolean isNoMore);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        /**
         * 獲取入庫單列表
         */
        Observable<BaseResult> getWarehousingOrderList(Map<String, Object> map);

    }
}
