package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.BasicUnitBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/29
 * Time: 15:52
 * Use:
 */
public class BasicUnitAdapter extends BaseQuickAdapter<BasicUnitBean, BaseViewHolder> {

    private boolean showDelete = false;

    public BasicUnitAdapter(@Nullable List<BasicUnitBean> data) {
        super(R.layout.item_basic_unit, data);
        addChildClickViewIds(R.id.iv_delete_basic_unit);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, BasicUnitBean item) {
        viewHolder.setText(R.id.tv_basic_unit, item.getContent());
        if (viewHolder.getAdapterPosition() == getData().size() - 1) {
            viewHolder.setTextColorRes(R.id.tv_basic_unit, R.color.theme_color);
        } else {
            viewHolder.setTextColorRes(R.id.tv_basic_unit, R.color.color_3c);
        }
        //沒有id的，就是系統自帶的默認的單位，不能刪除
        if (item.getId() != null) {
            viewHolder.setGone(R.id.iv_delete_basic_unit, !showDelete);
        } else {
            viewHolder.setGone(R.id.iv_delete_basic_unit, true);
        }
    }

    public void toggleDelete() {
        this.showDelete = !showDelete;
        notifyDataSetChanged();
    }
}
