package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.glide.GlideUtils;
import com.gingersoft.supply_chain.R;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/22
 * Time: 20:28
 * Use:
 */
public class ImageAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    private boolean notShowDelete;

    public ImageAdapter(boolean notShowDelete) {
        super(R.layout.item_image);
        addChildClickViewIds(R.id.iv_img, R.id.iv_img_delete);
        this.notShowDelete = notShowDelete;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, String s) {
        GlideUtils.display(getContext(), viewHolder.getView(R.id.iv_img), s);
        viewHolder.setGone(R.id.iv_img_delete, notShowDelete);
    }
}
