package com.gingersoft.supply_chain.mvp.ui.adapter

import androidx.core.content.ContextCompat
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil
import com.gingersoft.supply_chain.R
import com.gingersoft.supply_chain.mvp.bean.WarehouseOrderBean

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/4/28
 * Time: 14:19
 * Use:
 */
class WarehousingOrderListAdapter(data: MutableList<WarehouseOrderBean>?) : BaseQuickAdapter<WarehouseOrderBean, BaseViewHolder>(R.layout.item_warehousing_order_list, data) {

    override fun convert(holder: BaseViewHolder, item: WarehouseOrderBean) {
        holder.setText(R.id.tv_warehousing_order_no, item.warehousingOrderNo)
        holder.setText(R.id.tv_warehousing_order_createTime, item.createTime)
        holder.setText(R.id.tv_warehousing_order_species, String.format(context.getString(R.string.str_format_species_colon), item.purchaseFoodCount))
        holder.setText(R.id.tv_warehousing_order_createMember, String.format(context.getString(R.string.str_format_warehousing_member), item.userName))
        holder.setText(R.id.tv_warehousing_order_foods, item.foodName)
        holder.setText(R.id.tv_warehousing_order_createReason, item.storageType)

        val amount = String.format(context.getString(R.string.str_total_amount_colon_s), MoneyUtil.formatDouble(item.totalPrice))
        holder.setText(R.id.tv_warehousing_order_amount, TextUtil.getBoldSpannableString(amount, ContextCompat.getColor(context, R.color.required_color), 4, amount.length))

    }
}