package com.gingersoft.supply_chain.mvp.ui.adapter.binder;

import android.content.Context;

import com.chad.library.adapter.base.binder.QuickItemBinder;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.SnInOutBoundRecordDetailsBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/5/12
 * Time: 12:29
 * Use: sn碼入庫記錄詳情
 */
public class SnInRecordDetailsBinder extends QuickItemBinder<SnInOutBoundRecordDetailsBean.InventoryDetailsBean> {
    @Override
    public int getLayoutId() {
        return R.layout.item_sn_inout_bound_details;
    }

    @Override
    public void convert(@NotNull BaseViewHolder viewHolder, SnInOutBoundRecordDetailsBean.InventoryDetailsBean item) {
        Context context = viewHolder.itemView.getContext();
        viewHolder.setText(R.id.iv_inout_bound_details_type, String.format(context.getString(R.string.str_format_in_warehousing_type), item.getStorageType()));
        viewHolder.setText(R.id.iv_inout_bound_details_member, item.getUserName());
        viewHolder.setText(R.id.iv_inout_bound_details_time, String.format(context.getString(R.string.str_format_time), TimeUtils.StampToData(TimeUtils.DEFAULT_DATE_FORMAT, item.getCreateTime())));
        viewHolder.setText(R.id.iv_inout_bound_details_order_no, String.format(context.getString(R.string.str_format_order_no), item.getOrderNo()));
        viewHolder.setText(R.id.iv_inout_bound_details_remarks, String.format(context.getString(R.string.str_format_remark_colon), item.getRemarks()));
    }
}
