package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.core.restaurant.BrandInfo;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfo;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.mvp.content.PurchaseConstant;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;

import java.util.Objects;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/5/14
 * Time: 12:25
 * Use:
 */
public class UpdateRestaurantInfoPop extends ConfirmPopupView {

    @BindView(R2.id.tv_title)
    TextView tvTitle;
    @BindView(R2.id.tv_content)
    TextView tvContent;
    @BindView(R2.id.layout_brand_input)
    TextInputLayout layoutBrandInput;
    @BindView(R2.id.layout_restaurant_input)
    TextInputLayout layoutRestaurantInput;
    @BindView(R2.id.tv_confirm)
    QMUIAlphaButton tvConfirm;
    @BindView(R2.id.tv_cancel)
    QMUIAlphaButton tvCancel;
    @BindView(R2.id.ed_brand_input)
    TextInputEditText edBrandInput;
    @BindView(R2.id.ed_restaurant_input)
    TextInputEditText edRestaurantInput;

    public UpdateRestaurantInfoPop(@NonNull Context context) {
        super(context, R.layout.layout_update_restaurant_info);
    }


    @Override
    protected void onCreate() {
        super.onCreate();
        ButterKnife.bind(this);
        tvConfirm.setOnClickListener(v -> {
            RestaurantInfoManager.newInstance().setBrandInfo(new BrandInfo(Integer.parseInt(Objects.requireNonNull(edBrandInput.getText()).toString()), ""));
            RestaurantInfoManager.newInstance().setResturantInfo(new RestaurantInfo(Integer.parseInt(String.valueOf(edRestaurantInput.getText())), "", ""));
            dismiss();
        });
    }
}
