package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.common.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.threadPool.ThreadPoolManager;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.content.PurchaseConstant;
import com.gingersoft.supply_chain.mvp.ui.adapter.BuyIngredientsAdapter;
import com.lxj.xpopup.core.CenterPopupView;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/4/15
 * Time: 10:07
 * Use:
 */
public class WarehousingFoodDetailsPopup extends CenterPopupView {


    @BindView(R2.id.tv_goods_name)
    TextView tvGoodsName;
    @BindView(R2.id.tv_goods_price)
    QMUISpanTouchFixTextView tvGoodsPrice;
    @BindView(R2.id.tv_goods_no)
    TextView tvGoodsNo;
    @BindView(R2.id.tv_food_number)
    TextView tvFoodNumber;
    @BindView(R2.id.tv_food_total_amount)
    QMUISpanTouchFixTextView tvFoodTotalAmount;
    @BindView(R2.id.tv_goods_specification)
    TextView tvGoodsSpecification;
    @BindView(R2.id.iv_popup_close)
    ImageView ivPopupClose;
    private PurchaseFoodBean purchaseFoodBean;

    public WarehousingFoodDetailsPopup(@NonNull Context context, PurchaseFoodBean purchaseFoodBean) {
        super(context);
        this.purchaseFoodBean = purchaseFoodBean;
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.layout_warehousing_details_popup;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        ButterKnife.bind(this);
        popupInfo.autoOpenSoftInput = false;

        tvGoodsName.setText(purchaseFoodBean.getName());
        tvFoodNumber.setText(String.valueOf(purchaseFoodBean.getFoodQuantity()));
        tvGoodsNo.setText(purchaseFoodBean.getFoodNo());

        String price = String.format(getContext().getString(R.string.str_unit_price_colon_s), MoneyUtil.formatDouble(purchaseFoodBean.getUnitPrice()));
        tvGoodsPrice.setText(TextUtil.getBoldSpannableString(price, ContextCompat.getColor(getContext(), R.color.required_color), 3, price.length()));
        String totalAmountText = String.format(getContext().getString(R.string.str_total_amount_colon_s), MoneyUtil.formatDouble(MoneyUtil.priceCalculation(purchaseFoodBean.getUnitPrice(), purchaseFoodBean.getFoodQuantity())));
        tvFoodTotalAmount.setText(TextUtil.getBoldSpannableString(totalAmountText, ContextCompat.getColor(getContext(), R.color.required_color), 3, totalAmountText.length()));
        if (TextUtil.isNotEmptyOrNullOrUndefined(purchaseFoodBean.getPackingDescription())) {
            tvGoodsSpecification.setText(purchaseFoodBean.getPackingDescription());
        } else {
            tvGoodsSpecification.setText(purchaseFoodBean.getBasicUnitName());
        }
        ivPopupClose.setOnClickListener(this::onClick);
    }

    private void onClick(View v) {
        dismiss();
    }
}
