package com.gingersoft.gsa.cloud.table.mvp.action.discount;

import android.app.Activity;

import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import lombok.Builder;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-10-27
 * @update date: 2020-10-27
 * @description:食品優惠券邏輯
 */
@Builder
@Setter
public class MealCouponAction implements Strategy<MemberWalletCoupon> {

    private Activity context;

    /**
     * 選中的食品或套餐組
     */
    private List<OrderDetail> selectMixOrderMealList;

    private OnCallBackListener listener;

    private String cashStr ;

    @Override
    public void action(MemberWalletCoupon coupon) {
        if (listener == null || selectMixOrderMealList == null || selectMixOrderMealList.size() == 0) {
            return;
        }
        double mixTotalAomout = getMixTotalAomout(selectMixOrderMealList);
//        if(coupon.getAmount() > mixTotalAomout){
//            //金額折扣總額不能超過 套餐總金額
//            ArmsUtils.makeText(context, "優惠券金額不可以超過食品總金額!");
//            return;
//        }
        if (coupon.getBillMinAmount() > mixTotalAomout) {
            //最小金額
            ArmsUtils.makeText(context, "小於最小金額" +cashStr+ coupon.getBillMinAmount() + " 無法使用此食品優惠券");
            return;
        }
        listener.preformAddCoupon(coupon.clone());
    }

    @Override
    public void destroy() {

    }

    /**
     * 獲取套餐總金額
     *
     * @param mixOrderMealList
     * @return
     */
    private double getMixTotalAomout(List<OrderDetail> mixOrderMealList) {
        double mixTotalAomout = 0.0;
        for (OrderDetail orderDetail : mixOrderMealList) {
            mixTotalAomout = MoneyUtil.sum(mixTotalAomout, orderDetail.getPrice());
        }
        return mixTotalAomout;
    }

    public interface OnCallBackListener {

        void preformAddCoupon(MemberWalletCoupon discount);
    }

}
