package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.TableContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.cache.TableCache;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.TableService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;
import com.xuexiang.rxutil2.rxjava.RxSchedulerUtils;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.rx_cache2.DynamicKey;
import io.rx_cache2.EvictDynamicKey;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class TableModel extends BaseModel implements TableContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public TableModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public List<Food> queryDB_AllFoodList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryAllFoodByQueryBuilder();
        return foods;
    }

    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        return daoUtils.queryModifiersByFid(fid, mode);
    }

    @Override
    public Observable<TableBean> getTables(int restaurantId, boolean update) {
        return mRepositoryManager
                .obtainRetrofitService(TableService.class)
                .getTables(restaurantId)
                .compose(RxSchedulerUtils._io_main_o());
//        return Single.just(mRepositoryManager
//                .obtainRetrofitService(TableService.class)
//                .getTables(restaurantId))
//                .flatMap((Function<Single<TableBean>, SingleSource<TableBean>>) listSingle ->
//                        mRepositoryManager.obtainCacheService(TableCache.class)
//                                .getTables(listSingle,
//                                        new DynamicKey(1),
//                                        new EvictDynamicKey(update))
//                                .map(listReply -> listReply.getData()));
    }


    @Override
    public Single<BaseResult> getTable(int tableId, String tableNumber) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTable(tableId, tableNumber)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseOrderResponse> getOrderById(long orderId) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .getOrderById(orderId)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseOrderResponse> openTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .openTable(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseOrderResponse> turnTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .turnTable(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseOrderResponse> initTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .initTable(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> resetSkyorder(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .resetSkyorder(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> getSplitTables(int tableId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getSplitTables(tableId)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> splitTable(int tableId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .splitTable(tableId)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> getFoodSummarys(int restaurantId, boolean isDefault, byte businessType, boolean update) {
        return mRepositoryManager
                .obtainRetrofitService(TableService.class)
                .getFoodSummarys(restaurantId, isDefault, businessType)
                .compose(MyRxSchedulerUtils._io_main_f());
//        return Single.just(mRepositoryManager
//                .obtainRetrofitService(TableService.class)
//                .getFoodSummarys(restaurantId, isDefault, businessType))
//                .flatMap((Function<Single<BaseResult>, SingleSource<BaseResult>>) listSingle -> mRepositoryManager.obtainCacheService(TableCache.class)
//                        .getFoodSummarys(listSingle,
//                                new DynamicKey(1),
//                                new EvictDynamicKey(update))
//                        .map(listReply -> listReply.getData()));

    }

    @Override
    public Single<BaseResult> addScan(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .addScan(requestBody)
                .compose(MyRxSchedulerUtils._io_main_f());
    }


}