package com.gingersoft.gsa.cloud.table.mvp.model.cache;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;

import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.rx_cache2.DynamicKey;
import io.rx_cache2.EvictProvider;
import io.rx_cache2.LifeCache;
import io.rx_cache2.Reply;

/**
 * @作者: bin
 * @創建時間: 2021-03-26 11:06
 * @更新時間: 2021-03-26 11:06
 * @描述:
 */
public interface TableCache {

    @LifeCache(duration = 2, timeUnit = TimeUnit.MINUTES)
    Observable<Reply<TableBean>> getTables(Observable<TableBean> tables, DynamicKey idLastUserQueried, EvictProvider evictProvider);

    @LifeCache(duration = 2, timeUnit = TimeUnit.MINUTES)
    Observable<Reply<BaseResult>> getFoodSummarys(Observable<BaseResult> foodSummarys, DynamicKey idLastUserQueried, EvictProvider evictProvider);
}
